% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.w.transformation.R
\encoding{UTF-8}
\name{matrix.w.transformation}
\alias{matrix.w.transformation}
\title{Community data transformation}
\usage{
matrix.w.transformation(
  comm,
  transformation = "standardized",
  spp.weights = NULL,
  reference = NULL,
  type = 0,
  include = TRUE,
  notification = TRUE
)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as
rows. This matrix can contain either presence/absence or abundance data.}

\item{transformation}{Method to community data transformation, "none", "standardized", "weights"
or "beals" (Default transformation = "standardized").}

\item{spp.weights}{Vector with 0 or 1 to specify individual species weights (Default spp.weights = NULL).}

\item{reference}{Data to compute joint occurrences in \code{\link[vegan]{beals}} function. If NULL, comm is
used as reference to compute the joint occurrences (Default reference = NULL).}

\item{type}{Method to specifies how abundance values are used in \code{\link[vegan]{beals}} function, type = 0
presence/absence, type = 1 abundances are used to compute conditioned probabilities, type = 2 abundances
are used to compute weighted averages of conditioned probabilities or type = 3 abundances are used to
compute both conditioned probabilities and weighted averages (Default type = 0).}

\item{include}{Logical argument (TRUE or FALSE) to specify if target species are included when computing
the mean of the conditioned probabilities in \code{\link[vegan]{beals}} (Default include = TRUE).}

\item{notification}{Logical argument (TRUE or FALSE) to specify if notifications for missing observations
are to be shown (Default notification = TRUE).}
}
\value{
Transformed community matrix, where rows are communities and columns species.
}
\description{
Function to transformation community data and replace missing data. See details.
}
\details{
The function applies standardization/transformation for community data. The options
are: "none" no transformation is applied; "standardized" the community data is standardized
to row totals will be 1; "weights" community data is first "standardized" and when, individual
species weights are multiplied to each species entries; and "beals" option applies Beals smoothing
using the function \code{\link[vegan]{beals}}. The arguments "reference", "type" and "include" are the same
used in \code{\link[vegan]{beals}} function. Missing data are replaced by 0 after the standardization/transformation.
}
\note{
\strong{IMPORTANT}: Species sequence in the community data
matrix MUST be the same as the one in the reference matrix or in spp.weights vector. See
\code{\link{organize.syncsa}}.
}
\examples{
data(ADRS)
matrix.w.transformation(ADRS$community)
}
\references{
Pillar, V.D.; Duarte, L.d.S. (2010). A framework for
metacommunity analysis of phylogenetic structure. Ecology Letters, 13,
587-596.
De Cáceres, M.; Legendre, P. 2008. Beals smoothing revisited. Oecologia 156: 657–669.
}
\seealso{
\code{\link{syncsa}}, \code{\link{organize.syncsa}}, \code{\link{matrix.p}},
\code{\link{matrix.t}}, \code{\link{matrix.x}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{Auxiliary}
