% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_sql.R
\name{df_to_sql}
\alias{df_to_sql}
\title{Dataframe to SQL}
\usage{
df_to_sql(df, driver, server, database, sql_table_name, overwrite = FALSE, ...)
}
\arguments{
\item{df}{A `dataFrame` or `tibble` ie PopHealthData.}

\item{driver}{A driver for database ie "SQL Server"; must be passed in quotation.}

\item{server}{The unique name of your database server; must be passed in quotation.}

\item{database}{The name of the database to which you will write `df`; must be passed in quotation.}

\item{sql_table_name}{The name that `df` will be referred to in SQL database; must be passed in quotation.}

\item{overwrite}{If there is a SQL table with the same name whether it will be overwritten; defaults to FALSE.}

\item{...}{Function forwarding for additional functionality.}
}
\value{
A message confirming that a new  table has been created in a SQL `database`.
}
\description{
DataFrame to SQL; Write your DataFrame or Tibble directly to SQL from R
This wrapper function allows for the easy movement of your computed results in R
to a SQL Database for saving. The function uses a ODBC driver to establish a connection.
You will need to select a Database that your user has write-access to. The user
credentials are the same as your OS login details; as such this function will
most likely only work from you work computer.
}
\examples{
\dontrun{
library(odbc)
library(DBI)
health_data <- SangerTools::PopHealthData
df_to_sql(
  df = health_data,
  driver = "SQL SERVER",
  database = "DATABASE",
  sql_table_name = "New Table Name",
  overwrite = FALSE
)
}
}
