% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{synthetic_data}
\alias{synthetic_data}
\title{synthetic_data}
\usage{
synthetic_data(
  n,
  p,
  s0,
  error_std,
  type = "linear",
  scale = TRUE,
  signal = "constant"
)
}
\arguments{
\item{n}{number of observations}

\item{p}{number of covariates}

\item{s0}{sparsity (number of non-zero components of the true signal)}

\item{error_std}{Standard deviation of the Gaussian noise (linear regression only)}

\item{type}{dataset type ('linear' or 'logistic')}

\item{scale}{design matrix X has columns mean zero and standard deviation 1 (TRUE or FALSE)}

\item{signal}{non-zero components of the true signal ('constant' or 'deacy')}
}
\value{
Design matrix, response and true signal vector for linear and logistic regression
}
\description{
Generates synthetic linear and logistic regression data
}
\examples{
syn_data <- synthetic_data(n=100,p=200,s0=5,error_std=2)

# syn_data$X is an n by p design matrix
dim(syn_data$X)

# syn_data$y is a length n response vector
length(syn_data$y) 

# syn_data$true_beta is a length n response vector with only the first s0 entries non-zero
all(syn_data$true_beta[1:5]!=0)
all(syn_data$true_beta[-c(1:5)]==0)
}
