% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_NULLSeaSondeRCS_MUSIC}
\alias{seasonder_NULLSeaSondeRCS_MUSIC}
\title{Initialize NULL Data Structure for SeaSondeR MUSIC Analysis}
\usage{
seasonder_NULLSeaSondeRCS_MUSIC()
}
\value{
A tibble with pre-defined columns and empty values, ready to be populated with MUSIC analysis results.
}
\description{
This function initializes a NULL data structure for storing results of the MUSIC analysis in
SeaSondeR. The structure is designed as a tibble with pre-defined columns for range cells,
Doppler bins, and various MUSIC-related parameters.
}
\details{
The initialized tibble contains the following columns:
\itemize{
\item \code{range_cell}: Numeric vector representing range cell indices.
\item \code{doppler_bin}: Numeric vector for Doppler bin indices.
\item \code{range}: Numeric vector for range values.
\item \code{freq}: Numeric vector for frequencies.
\item \code{radial_v}: Numeric vector for radial velocities.
\item \code{cov}: A list to store covariance matrices.
\item \code{eigen}: A list to store eigenvalue decompositions.
\item \code{projections}: A list to store projection matrices.
\item \code{DOA_solutions}: A list to store Direction of Arrival (DOA) solutions.
\item \code{eigen_values_ratio}: Numeric vector for the ratio of eigenvalues.
\item \code{P1_check}: Logical vector indicating if the P1 criterion is satisfied.
\item \code{retained_solution}: Character vector for the type of retained solution (\code{"single"} or \code{"dual"}).
\item \code{DOA}: A list to store final DOA results.
\item \code{lonlat}: A list containing a data frame with longitude (\code{lon}) and latitude (\code{lat}) values.
}
}
\seealso{
\code{\link{seasonder_MUSICInitCov}} for initializing covariance matrices.
\code{\link{seasonder_MUSICInitEigenDecomp}} for initializing eigenvalue decompositions.
\code{\link{seasonder_MUSICInitProjections}} for initializing projection matrices.
\code{\link{seasonder_MUSICInitDOASolutions}} for initializing DOA solutions.
}
