% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_initializeAttributesSeaSondeRAPM}
\alias{seasonder_initializeAttributesSeaSondeRAPM}
\title{Initialize Attributes for a SeaSondeRAPM Object}
\usage{
seasonder_initializeAttributesSeaSondeRAPM(calibration_matrix, ...)
}
\arguments{
\item{calibration_matrix}{A 2 x b complex matrix, where b is the number of bearings for calibration.}

\item{...}{Additional named attributes that may override the defaults.}
}
\value{
A list containing initialized attributes for a SeaSondeRAPM object.
}
\description{
This function initializes attributes for a SeaSondeRAPM object, including metadata and properties.
}
\details{
The function initializes the following attributes:
\itemize{
\item \code{quality_matrix}: A 3 x b complex matrix for quality data, where b is the number of bearings.
\item \code{BEAR}: A numeric vector for bearings (degrees CCW from the site bearing).
\item \code{Type}: Character string for antenna pattern type.
\item \code{Creator}: Object creator name. Default is an empty character vector.
\item \code{SiteName}: Site name (not the same as SiteCode). Default is an empty character vector.
\item \code{SiteOrigin}: Numeric vector with two elements representing the Station GPS location. Default is \code{c(0,0)}.
\item \code{FileName}: Default is an empty character vector.
\item \code{CreateTimeStamp}: APM file creation time. Default is current system date and time.
\item \code{ProcessingSteps}: Processing steps applied to this object. Default is an empty character vector.
\item \code{AmplitudeFactors}: Numeric vector with two elements for the amplitude factors. Default is \code{c(0,0)}.
\item \code{AntennaBearing}: Site bearing (CW degrees from true north). Default is an empty numeric vector.
\item \code{StationCode}: 4-character station code. Default is an empty character vector.
\item \code{BearingResolution}: In degrees. Default is an empty numeric vector.
\item \code{Smoothing}: Numeric vector indicating smoothing applied to the antenna pattern. Default is an empty numeric vector.
\item \code{CommentLine}: Metadata lines in the data file not matching any other attribute. Default is an empty character vector.
\item \code{FileID}: File's UUID. Default is an empty character vector.
\item \code{PhaseCorrections}: Numeric vector with two elements for phase corrections. Default is \code{c(0,0)}.
}
}
\examples{
  # Initialize attributes for a dummy calibration matrix
  attrs <- seasonder_initializeAttributesSeaSondeRAPM(matrix(1:6, nrow = 3))
}
\seealso{
\code{\link{seasonder_createSeaSondeRAPM}},
\code{\link{seasonder_validateAttributesSeaSondeRAPM}}
}
