% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSW.R
\name{seasonder_readCSSWHeader}
\alias{seasonder_readCSSWHeader}
\title{Read CSSW File Header}
\usage{
seasonder_readCSSWHeader(
  connection,
  current_specs,
  endian = "big",
  parent_key = NULL,
  keys_so_far = c("CSSW", "HEAD"),
  specs_key_size = NULL
)
}
\arguments{
\item{connection}{A binary connection from which to read the CSSW file header.}

\item{current_specs}{A list representing the specification for the header; may contain nested subkeys.}

\item{endian}{A character string indicating the byte order for reading numeric values ("big" or "little").}

\item{parent_key}{(Optional) A list with information from the parent key block, used when processing nested keys.}

\item{keys_so_far}{A character vector of keys already processed, used to avoid recursive loops. Defaults to c("CSSW", "HEAD").}

\item{specs_key_size}{A specification for reading the key size block, often obtained from YAML specs.}
}
\value{
A list containing the parsed CSSW header information. The returned list may be empty if a termination
condition is encountered.
}
\description{
This function reads the header section of a CSSW file from a binary connection. The CSSW file header
contains a set of key blocks formatted according to the SeaSonde CSSW specification. The header section
is processed recursively and terminates when one of the following conditions is met:
\itemize{
\item A key with name "BODY" is encountered. In this case, the connection is rewound by 8 bytes
to allow subsequent processing of the body.
\item A key that is not defined in \code{current_specs} but is already present in the
\code{keys_so_far} vector is encountered (indicative of repeated keys), which triggers termination.
}
}
\details{
When no subkeys are specified in \code{current_specs} (i.e. \code{current_specs} comprises only
simple field definitions), the function delegates the processing to \code{seasonder_readCSSWFields}.

The function processes the CSSW header recursively:
\itemize{
\item If \code{current_specs} contains only field definitions, \code{seasonder_readCSSWFields} is called.
\item When a key named "BODY" is encountered, it signifies the beginning of the body section; the
function rewinds the connection 8 bytes and stops processing further keys.
\item If a key is encountered that is not defined in \code{current_specs} but is already present in
\code{keys_so_far}, the function also rewinds the connection 8 bytes and terminates header reading.
\item Otherwise, the function updates \code{keys_so_far}, handles special cases (e.g., key "cs4h"), and
calls itself recursively to process nested keys.
}
}
