% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{self_spectra_to_dB}
\alias{self_spectra_to_dB}
\title{Convert Self-Spectra Power to dB}
\usage{
self_spectra_to_dB(spectrum_values, receiver_gain)
}
\arguments{
\item{spectrum_values}{A numeric vector. The power values in linear scale.}

\item{receiver_gain}{A numeric scalar. The receiver gain in decibels (dB).}
}
\value{
A numeric vector of power values in decibels (dB).
}
\description{
This function converts self-spectra power values from a linear scale to decibels (dB). The transformation considers the receiver gain to adjust the power measurements accordingly.
}
\details{
The conversion follows the equation:
\deqn{dB = 10 \log_{10}(|P|) - G}
where:
\itemize{
\item \( dB \) is the power in decibels,
\item \( P \) is the self-spectra power in linear scale,
\item \( G \) is the receiver gain in decibels.
}

Absolute values of power are used to ensure valid logarithmic calculations.
}
\seealso{
\code{\link{dB_to_self_spectra}} for the reverse conversion.
}
