% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMixt.R
\name{rMixt}
\alias{rMixt}
\title{Random number generation for bidimensional parsimonious mixtures of MSEN or MTIN distributions}
\usage{
rMixt(n, k, Pi, mu, cov.model, lambda, delta, gamma, theta, density)
}
\arguments{
\item{n}{An integer specifying the number of data points to be simulated.}

\item{k}{An integer indicating the number of groups in the data.}

\item{Pi}{A vector of length \code{k} representing the probability of belonging to the \code{k} groups for each data point.}

\item{mu}{A matrix of means with 2 rows and \code{k} columns.}

\item{cov.model}{A character indicating the parsimonious structure of the scale matrices. Possible values are:
"EII", "VII", "EEI", "VEI", "EVI", "VVI", "EEE", "VEE", "EVE", "EEV", "VVE", "VEV", "EVV" or "VVV".}

\item{lambda}{A numeric vector of length \code{k}, related to the scale matrices (see Punzo et al., 2016),
which determines the volumes of the mixture components. Each element must be greater than 0.
Required for all the parsimonious structures.}

\item{delta}{A numeric vector of length \code{k}, related to the scale matrices (see Punzo et al., 2016),
which determines the shapes of the mixture components. Each element must be between 0 and 1.
Required for all the parsimonious structures, with the exclusion of "EII" and "VII".}

\item{gamma}{A numeric vector of length \code{k}, related to the scale matrices (see Punzo et al., 2016),
which determines the orientation of the mixture components. Each element represents an angle expressed in radian unit.
Required for the "EEE", "VEE", "EVE", "EEV", "VVE", "VEV", "EVV" or "VVV" parsimonious structures.}

\item{theta}{A vector of length \code{k} representing the tailedness parameters.}

\item{density}{A character indicating the density of the mixture components. Possible values are: "MSEN" or "MTIN".}
}
\value{
A list with the following elements:
\item{X}{A data matrix with \code{n} rows and 2 columns.}
\item{Sigma}{An array of dimension 2 x 2 x \code{k} for the generated scale matrices.}
\item{Size}{The size of each generated group.}
}
\description{
Random number generation for bidimensional parsimonious mixtures of MSEN or MTIN distributions
}
\examples{
n <- 50
k <- 2
Pi <- c(0.5, 0.5)
mu <- matrix(c(0, 0, 4, 5), 2, 2)
cov.model <- "EEE"
lambda <- c(0.5, 0.5)
delta <- c(0.7, 0.7)
gamma <- c(2.62, 2.62)
theta <- c(0.1, 0.1)
density <- "MSEN"
data <- rMixt(n, k, Pi, mu, cov.model, lambda, delta, gamma, theta, density)
}
\references{
Punzo A., Browne R. and McNicholas P.D. (2016). Hypothesis Testing for Mixture Model Selection.
\emph{Journal of Statistical Computation and Simulation}, \strong{86}(14), 2797-2818.
}
