% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{RunLeiden}
\alias{RunLeiden}
\title{Run Leiden clustering algorithm}
\usage{
RunLeiden(
  object,
  method = deprecated(),
  leiden_method = c("leidenbase", "igraph"),
  partition.type = c("RBConfigurationVertexPartition", "ModularityVertexPartition",
    "RBERVertexPartition", "CPMVertexPartition", "MutableVertexPartition",
    "SignificanceVertexPartition", "SurpriseVertexPartition"),
  leiden_objective_function = c("modularity", "CPM"),
  initial.membership = NULL,
  node.sizes = NULL,
  resolution.parameter = 1,
  random.seed = 1,
  n.iter = 10
)
}
\arguments{
\item{object}{An adjacency matrix or adjacency list.}

\item{method}{DEPRECATED.}

\item{leiden_method}{Choose from the leidenbase ("leidenbase") or igraph ("igraph") packages for running leiden.
Default is "leidenbase"}

\item{partition.type}{Type of partition to use for Leiden algorithm.
Defaults to "RBConfigurationVertexPartition", see
https://cran.rstudio.com/web/packages/leidenbase/leidenbase.pdf for more options.}

\item{leiden_objective_function}{objective function to use if `leiden_method = "igraph"`.
See \code{\link[igraph]{cluster_leiden}} for more information.
Default is "modularity".}

\item{initial.membership}{Passed to the `initial_membership` parameter
of `leidenbase::leiden_find_partition`.}

\item{node.sizes}{Passed to the `node_sizes` parameter of
`leidenbase::leiden_find_partition`.}

\item{resolution.parameter}{A parameter controlling the coarseness of the clusters
for Leiden algorithm. Higher values lead to more clusters. (defaults to 1.0 for
partition types that accept a resolution parameter)}

\item{random.seed}{Seed of the random number generator, must be greater than 0.}

\item{n.iter}{Maximal number of iterations per random start}
}
\description{
Returns a vector of partition indices.
}
\references{
igraph-based leiden clustering is adapted from \code{\link[BPCells]{cluster_graph_leiden}}
(MIT License), author: Benjamin Parks.  Reordering of igraph leiden cluster numbers by
cluster size adapted from rliger v2.0 `.labelClustBySize` (GPL-3.0 License) authors:
Josh Welch & Yichen Wang
}
\concept{clustering}
