% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Demography_functions.R
\name{Estimate_eigenvectors}
\alias{Estimate_eigenvectors}
\title{Estimate the left and right eignvectors (Reproductive value: v and Stable age distribution: w)}
\usage{
Estimate_eigenvectors(n = 1000, data, M.estimators = NULL)
}
\arguments{
\item{n}{The number of simulations to be run}

\item{data}{A multi-level list of the class `Demography.inputs` produced from the
`create_data_input` function and then manually completed.}

\item{M.estimators}{Any specific natural mortality estimators to be included in the analysis.
 Must be a single estimator or a vector of estimators. These can include: "Pet.Wro",
"Jensen.mat","Chen.Yuan","Then_hoenig","Then_pauly", "Jensen.mat","Charnov" or
"Chen.Want". If none are specified then all applicable estimators could be chosen.}
}
\value{
A dataframe with the mean and 95\% quantiles for each eigenvector for each age
    class
}
\description{
This function performs a Monte Carlo simulation analysis which determines
    the distributions of the left and right eigenvector. To facilitate this, maximum age
    is fixed as the minimum value + 20\% for the species.
}
\examples{
# load Silky shark data produced by create_data_input()
# Type `?create_data_input()` for details
data("Silky_data")

# Run function to get Eigenvectors from  Monte Carlo simulations for
# all available natural mortality estimators. Set n = at least 1000 for full
# analysis but use n = 100 for testing

Estimate_eigenvectors(n = 100, Silky_data)
}
