% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.r
\name{sr_vcov}
\alias{sr_vcov}
\title{Compute variance covariance of Sharpe Ratios.}
\usage{
sr_vcov(X,vcov.func=vcov,ope=1)
}
\arguments{
\item{X}{an \eqn{n \times p}{n x p} matrix of observed returns.
It not a matrix, but a numeric of length \eqn{n}{n}, then it is
coerced into a \eqn{n \times 1}{n x 1} matrix.}

\item{vcov.func}{a function which takes an object of class \code{lm},
and computes a variance-covariance matrix.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized' 
units for some epoch, that is, 'per square root epoch', though returns 
are observed at a frequency of \code{ope} per epoch. 
The default value is 1, meaning the code will not attempt to guess
what the observation frequency is, and no annualization adjustments
will be made.}
}
\value{
a list containing the following components:
\item{SR}{a vector of (annualized) Sharpe ratios.}
\item{Ohat}{a \eqn{p \times p}{p x p} variance covariance matrix.}
\item{p}{the number of assets.}
}
\description{
Computes the variance covariance matrix of sample Sharpe ratios.
}
\details{
Given \eqn{n} contemporaneous observations of \eqn{p} returns
streams, this function estimates the asymptotic variance
covariance matrix of the vector of sample Sharpes, 
\eqn{\left[\zeta_1,\zeta_2,\ldots,\zeta_p\right]}{[zeta1,zeta2,...,zetap]}

One may use the default method for computing covariance,
via the \code{\link{vcov}} function, or via a 'fancy' estimator,
like \code{sandwich:vcovHAC}, \code{sandwich:vcovHC}, \emph{etc.}

This code first estimates the covariance of the \eqn{2p} vector of 
the vector \eqn{x} stacked on its Hadamard square, \eqn{x^2}. This is
then translated back to a variance covariance on the vector of
sample Sharpe ratios via the Delta method.
}
\examples{
X <- matrix(rnorm(1000*3),ncol=3)
colnames(X) <- c("ABC","XYZ","WORM")
Sigmas <- sr_vcov(X)
# make it fat tailed:
X <- matrix(rt(1000*3,df=5),ncol=3)
Sigmas <- sr_vcov(X)
\donttest{
if (require(sandwich)) {
Sigmas <- sr_vcov(X,vcov.func=vcovHC)
}
}
# add some autocorrelation to X
Xf <- filter(X,c(0.2),"recursive")
colnames(Xf) <- colnames(X)
Sigmas <- sr_vcov(Xf)
\donttest{
if (require(sandwich)) {
Sigmas <- sr_vcov(Xf,vcov.func=vcovHAC)
}
}
# should run for a vector as well
X <- rnorm(1000)
SS <- sr_vcov(X)

}
\references{
Sharpe, William F. "Mutual fund performance." Journal of business (1966): 119-138.
\url{https://ideas.repec.org/a/ucp/jnlbus/v39y1965p119.html}

Lo, Andrew W. "The statistics of Sharpe ratios." Financial Analysts Journal 58, no. 4 
(2002): 36-52. \url{https://www.ssrn.com/paper=377260}
}
\seealso{
\code{\link{reannualize}}

sr-distribution functions, \code{\link{dsr}}

Other sr: 
\code{\link{as.sr}()},
\code{\link{confint.sr}()},
\code{\link{dsr}()},
\code{\link{is.sr}()},
\code{\link{plambdap}()},
\code{\link{power.sr_test}()},
\code{\link{predint}()},
\code{\link{print.sr}()},
\code{\link{reannualize}()},
\code{\link{se}()},
\code{\link{sr}},
\code{\link{sr_equality_test}()},
\code{\link{sr_test}()},
\code{\link{sr_unpaired_test}()},
\code{\link{summary.sr}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\concept{sr}
\keyword{univar}
