% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.r
\name{sric}
\alias{sric}
\title{Sharpe Ratio Information Coefficient}
\usage{
sric(z.s)
}
\arguments{
\item{z.s}{an object of type \code{sropt}}
}
\value{
The Sharpe Ratio Information Coefficient.
}
\description{
Computes the Sharpe Ratio Information Coefficient of
Paulsen and Soehl, an asymptotically unbiased estimate of
the out-of-sample Sharpe of the in-sample Markowitz portfolio.
}
\details{
Let \eqn{X}{X} be an observed \eqn{T \times k}{T x k} matrix whose
rows are i.i.d. normal. Let \eqn{\mu}{mu} and \eqn{\Sigma}{Sigma} be
the sample mean and sample covariance. The Markowitz portfolio is
\deqn{w = \Sigma^{-1}\mu,}{w = Sigma^-1 mu,}
which has an in-sample Sharpe of 
\eqn{\zeta = \sqrt{\mu^{\top}\Sigma^{-1}\mu}.}{zeta = sqrt(mu' Sigma^-1 mu).}

The \emph{Sharpe Ratio Information Criterion} is defined as
\deqn{SRIC = \zeta - \frac{k-1}{T\zeta}.}{SRIC = zeta - ((k-1) / (T zeta)).}
The expected value (over draws of \eqn{X}{X} and of future returns)
of the \eqn{SRIC}{SRIC} is equal to the expected value of the out-of-sample
Sharpe of the (in-sample) portfolio \eqn{w}{w} (again, over the same draws.)
}
\examples{
# generate some sropts
nfac <- 3
nyr <- 5
ope <- 253
# simulations with no covariance structure.
# under the null:
set.seed(as.integer(charToRaw("fix seed")))
Returns <- matrix(rnorm(ope*nyr*nfac,mean=0,sd=0.0125),ncol=nfac)
asro <- as.sropt(Returns,drag=0,ope=ope)
srv <- sric(asro)

}
\references{
Paulsen, D., and Soehl, J. "Noise Fit, Estimation Error, and Sharpe Information Criterion."
arxiv preprint (2016): \url{https://arxiv.org/abs/1602.06186}
}
\seealso{
Other sropt Hotelling: 
\code{\link{asnr_confint}()},
\code{\link{inference}()}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\concept{sropt Hotelling}
