% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewise.linear.R
\name{piecewise.linear}
\alias{piecewise.linear}
\title{Creates a piecewise linear model}
\usage{
piecewise.linear(
  x,
  y,
  middle = 1,
  CI = FALSE,
  bootstrap.samples = 1000,
  sig.level = 0.05
)
}
\arguments{
\item{x}{Vector of data for the x-axis.}

\item{y}{Vector of data for the y-axis}

\item{middle}{A scalar in \eqn{[0,1]}. This represents the range that the change-point
can occur in.  \eqn{0} means the change-point must occur at the middle of the range of 
x-values.  \eqn{1} means that the change-point can occur anywhere along the range of the 
x-values.}

\item{CI}{Whether or not a bootstrap confidence interval should be calculated. Defaults to
FALSE because the interval takes a non-trivial amount of time to calculate}

\item{bootstrap.samples}{The number of bootstrap samples to take when calculating the CI.}

\item{sig.level}{What significance level to use for the confidence intervals.}
}
\value{
A list of 5 elements is returned: \describe{
  \item{change.point}{The estimate of \eqn{\alpha}.}
  \item{model}{The resulting \code{lm} object once \eqn{\alpha} is known. }
  \item{x}{The x-values used.}
  \item{y}{The y-values used.}
  \item{CI}{Whether or not the confidence interval was calculated.}
  \item{intervals}{If the CIs where calculated, this is a matrix of the
                   upper and lower intervals.}
}
}
\description{
Fit a degree 1 spline with 1 knot point where the location of the 
knot point is unknown.
}
\details{
The bootstrap samples are taken by resampling the raw data points.  
  Sometimes a more appropriate bootstrap sample would be to calculate the residuals and 
  then add a randomly selected residual to each y-value.
}
\examples{
data(Arkansas)
x <- Arkansas$year
y <- Arkansas$sqrt.mayflies

model <- piecewise.linear(x,y, CI=FALSE)
plot(model)
print(model)
predict(model, 2001)
}
\references{
Chiu, G. S., R. Lockhart, and R. Routledge. 2006. Bent-cable regression 
theory and applications. Journal of the American Statistical Association 
101:542-553.

Toms, J. D., and M. L. Lesperance. 2003. Piecewise regression: a tool for 
identifying ecological thresholds. Ecology 84:2034-2041.
}
\seealso{
The package \code{segmented} has a much more general implementation
  of this analysis and users should preferentially use that package.
}
