% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigopt_api_wrapper.R
\name{create_suggestion}
\alias{create_suggestion}
\title{Create a suggestion for an experiment}
\usage{
create_suggestion(experiment_id, body = NULL)
}
\arguments{
\item{experiment_id}{the id of an experiment to create an suggestion for}

\item{body}{POST body of create request}
}
\value{
suggestion created by SigOpt
}
\description{
Create a suggestion for an experiment
}
\examples{
env <- Sys.getenv("NOT_CRAN")
if (!identical(env, "true")) {
0
} else {
experiment <- create_experiment(list(
  name="R test experiment",
  parameters=list(
    list(name="x1", type="double", bounds=list(min=0, max=100)),
    list(name="x2", type="double", bounds=list(min=0, max=100))
  )
))
create_suggestion(experiment$id)}
}
