% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{population}
\alias{population}
\title{Generates a RDS Population}
\usage{
population(
  N = 1000,
  p.ties = 0.33,
  minVal = 0,
  maxVal = 300,
  zeros = 2,
  dis_type = "rexp",
  skew = 0.05,
  pr = 0.33,
  pa = 0.33,
  atype_char = "NULL",
  atype_res = "NULL"
)
}
\arguments{
\item{N}{Population size.}

\item{p.ties}{Number of ties to be in the population.}

\item{minVal}{The minimum degree size an individual in the population can have.}

\item{maxVal}{The maximum degree size an individual in the population can have.}

\item{zeros}{The maximum number of zeros the population can have}

\item{dis_type}{Specify the base distribution of the degrees. ("rnorm, rexp or runif")}

\item{skew}{is needed when the distribution is left- or right-skewed. When selecting
the value for the skewness, it is advisable to first observe the range of
values given from the rep function and to see whether the maximum value of
the distribution is close to the defined maximal.}

\item{pr}{Proportion of individuals that has '1' as the response in the
response variable.}

\item{pa}{Proportion of individuals that has '1' as their character in the
independent variable.}

\item{atype_char}{Defines how the independent variable is associated with other
external factors. "NULL" when it needs to be randomly distributed. If it
needs to be associated with the network size; use "net". It can be associated
with network size only. You must note these abbreviations when you associate
them with these variables: "network size = net."}

\item{atype_res}{Defines how the response variable is associated with other
external factors."NULL" is to be randomly distributed. If it needs to be
associated with both independent v; use "char * net". Can associate with the
network size and the independent variable abbreviations when needed to
associate with these variables. "network size = net", "independent dichotomous
variable = char."}
}
\value{
A simulated population with desired characteristics.
}
\description{
Generates RDS populations according to the user's preferred variability.
Do note the computer capacities when using the function since it can affect
the functionality of the methods used. A population size of 10,000 can be
produced with a RAM of 4GB without an issue. But if higher population sizes
are needed, then higher RAM is needed. The produced population consists of
the degree size, a dichotomous independent variable, a dichotomous response
variable and the IDs of the respondents in the network of each response.
}
\examples{
\donttest{
RDS.population <- population(N = 1000,p.ties = 0.6,minVal = 10,zeros = 0,
pr = .5,pa = .1, atype_char = "net",atype_res = "net*char")
}
# This function may take considerable time to produce output, depending on
# the computer's performance. For a quick reference to the expected result,
# a saved version of the output is available.
data(RDS.population)
}
