% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist_spde.R
\name{sim_ays_covar_spde}
\alias{sim_ays_covar_spde}
\title{Simulate age-year-space covariance using SPDE approach}
\usage{
sim_ays_covar_spde(
  sd = 2.8,
  range = 300,
  model = "spde",
  phi_age = 0.5,
  phi_year = 0.9,
  group_ages = 5:20,
  group_years = NULL,
  mesh,
  barrier.triangles
)
}
\arguments{
\item{sd}{Variance of the process (can be age-specific).}

\item{range}{Decorrelation range.}

\item{model}{Either \code{"barrier"} or \code{"spde"}; determines how the precision matrix \code{Q} is generated.}

\item{phi_age}{Autocorrelation through ages. Can be a single value or a vector the same length as \code{ages}.}

\item{phi_year}{Autocorrelation through years. Can be a single value or a vector the same length as \code{years}.}

\item{group_ages}{Ages to group together for shared space-age-year variance.}

\item{group_years}{Years to group together for shared space-age-year variance.}

\item{mesh}{The mesh used to generate the precision matrix.}

\item{barrier.triangles}{The set of mesh triangles that define the barrier (used only in the barrier model).}
}
\value{
A function that can be passed to \code{\link[=sim_distribution]{sim_distribution()}} as the \code{ays_covar} argument.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Returns a function for use inside \code{\link[=sim_distribution]{sim_distribution()}} to generate the error term.
}
\examples{
\donttest{
if (requireNamespace("INLA")) {

  # Make a grid
  my_grid <- make_grid(res = c(10, 10))

  # Make a mesh based on the grid
  my_mesh <- make_mesh(my_grid)

  # Simulate and plot
  sim <- sim_abundance(ages = 1:10, years = 1:10) |>
    sim_distribution(
      grid = my_grid,
      ays_covar = sim_ays_covar_spde(
        phi_age = 0.8,
        phi_year = 0.1,
        model = "spde",
        mesh = my_mesh
      ),
      depth_par = sim_parabola(mu = 200, sigma = 50)
    )

  plot_distribution(sim, ages = 1:5, years = 1:5, type = "heatmap")
}
}

}
