% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_STIR_tibble.R
\name{calculate_STIR_tibble}
\alias{calculate_STIR_tibble}
\title{Calculate STIR tibble}
\usage{
calculate_STIR_tibble(var_MGMT_data)
}
\arguments{
\item{var_MGMT_data}{a \code{management_df} that contains the management information}
}
\value{
a tibble with all management operations and STIR values
}
\description{
A function that calculates the STIR value of all operations in a \code{management_df}.
The output is returned as a tibble.
}
\details{
The function is mainly a helper function for the \code{\link[=tillage_intensity]{tillage_intensity()}} function.
}
\examples{

#example that returns a tibble with all operations that have a STIR value
calculate_STIR_tibble(EXAMPLE_data)

}
\seealso{
\itemize{
\item \code{\link[=STIR]{STIR()}} for the calculation of a \code{STIR} value for operations
\item \code{\link[=STIR_values_LUT]{STIR_values_LUT()}} for the reference data used for tillage operations
\item \code{\link[=calculate_indicators]{calculate_indicators()}} to calculate all management indicators
for a \code{management_df}
\item \code{\link[=tillage_intensity]{tillage_intensity()}} aggregates the STIR values
}
}
