% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_management_df.R
\name{check_management_df}
\alias{check_management_df}
\title{Check management_df for consitency}
\usage{
check_management_df(var_MGMT_data)
}
\arguments{
\item{var_MGMT_data}{an object of the \code{\link[=management_df]{management_df()}} class}
}
\value{
a test_report list (only returned if some tests failed)
}
\description{
The function checkes objects of the class \code{\link[=management_df]{management_df()}} for internal consistency.
It formally checks the class and the column names.
Additionally, the function checks if dates are consistently increasing
and if all organic amendments, tillage and sowing devices and crops
are in the relevant look-up-tables. It is checked if the are operations
where the device is not mentioned.
Furthermore, the amount of organic amendments (<100t/ha) and
N fertilizer (<100kgN/ha) application rates per event are checked.
The depth of tillage operations are compared with the min and max depth
from the \code{STIR_value_LUT}.
Finally, the order of tillage, sowing and harvest operations are checked
for plausibility (see details for more information).
}
\details{
The order of tillage, sowing and harvest operations are checked with the following assumptions:
\itemize{
\item after "stubble_cultivation" the following operations are allowed: "stubble_cultivation", "primary_tillage", "seedbed_preparation", "sowing_main_crop", "sowing_cover_crop"
\item after "primary_tillage" the following operations are allowed: "primary_tillage", "seedbed_preparation", "sowing_main_crop", "sowing_cover_crop"
\item after "seedbed_preparation" the following operations are allowed: "stubble_cultivation", "seedbed_preparation", "sowing_main_crop", "sowing_cover_crop"
\item after "sowing_main_crop" the following operations are allowed: "sowing_main_crop", "harvest_main_crop", "sowing_cover_crop"
\item after "sowing_cover_crop" the following operations are allowed: "stubble_cultivation", "primary_tillage", "seedbed_preparation", "sowing_main_crop", "sowing_cover_crop", "harvest_main_crop"
\item after "harvest_main_crop" the following operations are allowed: "harvest_main_crop", "straw_removal", "hay_removal", "stubble_cultivation", "primary_tillage", "seedbed_preparation", "sowing_main_crop", "sowing_cover_crop"
\item after "straw_removal" the following operations are allowed: "harvest_main_crop", "straw_removal", "stubble_cultivation", "primary_tillage", "seedbed_preparation", "sowing_main_crop", "sowing_cover_crop"
\item after "hay_removal" the following operations are allowed: "harvest_main_crop", "hay_removal", "stubble_cultivation", "primary_tillage", "seedbed_preparation", "sowing_main_crop", "sowing_cover_crop"
}

Additionally, there are exceptions for potato crops: "bedder" can be used after a "potato_planter" and "mulching" can be applied before a "potato_harvester"
}
\examples{
#example input
check_management_df(EXAMPLE_data)
}
\seealso{
\itemize{
\item \code{\link[=management_df]{management_df()}} for creating an management_df
\item \code{\link[=management_df_from_excel]{management_df_from_excel()}} for importing a management_df from an excel template
}
}
