% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTesting.R
\name{Std_Curve}
\alias{Std_Curve}
\title{Elemental concentration in solution from absorbance or emission values}
\usage{
Std_Curve(C_Std = C_Std, A_E_Std = A_E_Std, A_E_Sample = A_E_Sample,...)
}
\arguments{
\item{C_Std}{Concentration of the element in the working standard solutions (mg/L)}

\item{A_E_Std}{Absorbance or Emission reading of the working standard solutions}

\item{A_E_Sample}{Absorbance or Emission reading of the sample solutions}

\item{...}{Any other arguments that can be passed to base plot, such as main = "title", xlab = "Emission", ylab = "Concentration"}
}
\value{
Sample_mgL - Concentration of the element under consideration in the solution used for absorbance or emission reading (mg/L)
}
\description{
The concentration of the element in question is obtained by this function based on absorbance or emission values corresponding to the concentrations of that element in the working standard solutions.
}
\details{
For elements like phosphorus (P), sulphur (S), boron (B), the determination of concentration in the extract is done by a spectrophotometer based on absorbance readings corresponding to different known concentrations. For elements like potassium (K), sodium (Na), the determination of concentration in the extract is done by a flame photometer based on emission readings corresponding to different known concentrations. In each case, a standard curve is fitted between the absorbance or emission readings and the concentrations of the particular element in the working standard solutions. A linear regression equation can be fitted to the curve, based on which the concentration of the element under consideration in the sample extract can be determined.
}
\examples{
with(df_Std_Curve, Std_Curve(C_Std = C_Std, A_E_Std = A_E_Std,
A_E_Sample = A_E_Sample, xlab = "Emission", ylab = "Concentration"))

}
