% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rownames.R
\name{rownames}
\alias{rownames}
\alias{rn2col}
\alias{col2rn}
\alias{has_rn}
\alias{rm_rn}
\alias{set_rn}
\alias{add_rowid}
\title{Helpers for Working With Row Names}
\usage{
rn2col(data, name = ".rn")

col2rn(data, name = ".rn")

has_rn(data)

rm_rn(data)

set_rn(data, value)

add_rowid(data, name = ".rowid")
}
\arguments{
\item{data}{An object that inherits from class \code{data.frame}. Typically
a \code{soma_adat} class object.}

\item{name}{Character. The name of the column to move.}

\item{value}{Character. The new set of names for the data frame.
If duplicates exist they are modified on-the-fly via \code{\link[=make.unique]{make.unique()}}.}
}
\value{
All functions attempt to return an object of the same class as
the input with fully intact and unmodified attributes (aside from those
required by the desired action). \code{\link[=has_rn]{has_rn()}} returns a scalar logical.
}
\description{
Easily move row names to a column and vice-versa without the unwanted
side-effects to object class and attributes. Drop-in replacement for
\code{tibble::rownames_to_column()} and \code{tibble::column_to_rownames()} which
can have undesired side-effects to complex object attributes.
Does not import any external packages, modify the environment, or change
the object (other than the desired column). When using \code{\link[=col2rn]{col2rn()}}, if
explicit row names exist, they are overwritten with a warning. \code{\link[=add_rowid]{add_rowid()}}
does \emph{not} affect row names, which differs from \code{tibble::rowid_to_column()}.
}
\section{Functions}{
\itemize{
\item \code{rn2col()}: moves the row names of \code{data} to an explicit column
whether they are explicit or implicit.

\item \code{col2rn()}: is the inverse of \code{\link[=rn2col]{rn2col()}}. If row names exist, they
will be overwritten (with warning).

\item \code{has_rn()}: returns a boolean indicating whether the data frame
has explicit row names assigned.

\item \code{rm_rn()}: removes existing row names, leaving only "implicit" row names.

\item \code{set_rn()}: sets (and overwrites) existing row names for data frames only.

\item \code{add_rowid()}: adds a sequential integer row identifier; starting at \code{1:nrow(data)}.
It does \emph{not} remove existing row names currently, but may in the future
(please code accordingly).

}}
\examples{
df <- data.frame(a = 1:5, b = rnorm(5), row.names = LETTERS[1:5])
df
rn2col(df)              # default name is `.rn`
rn2col(df, "AptName")   # pass `name =`

# moving columns
df$mtcars <- sample(names(mtcars), 5)
col2rn(df, "mtcars")   # with a warning

# Move back and forth easily
# Leaves original object un-modified
identical(df, col2rn(rn2col(df)))

# add "id" column
add_rowid(mtcars)

# remove row names
has_rn(mtcars)
mtcars2 <- rm_rn(mtcars)
has_rn(mtcars2)
}
