# Copyright (C) 2011 Jelmer Ypma. All Rights Reserved.
# This code is published under the GPL.
#
# File:   GQN.R
# Author: Jelmer Ypma
# Date:   31 March 2011
#
# This code is based on code from www.sparse-grids.de
# with permission from the authors.
#
# Input: 
# Output: 

GQN <- function( level ) {
  switch( level,
          { # case 1
            n = c(0.0000000000000000e+000)
            w = c(1.0000000000000000e+000)
          },
          { # case 2
            n = c(1.0000000000000002e+000)
            w = c(5.0000000000000000e-001)
          },
          { # case 3
            n = c(0.0000000000000000e+000, 1.7320508075688772e+000)
            w = c(6.6666666666666663e-001, 1.6666666666666674e-001)
          },
          { # case 4
            n = c(7.4196378430272591e-001, 2.3344142183389773e+000)
            w = c(4.5412414523193145e-001, 4.5875854768068498e-002)
          },
          { # case 5
            n = c(0.0000000000000000e+000, 1.3556261799742659e+000, 2.8569700138728056e+000)
            w = c(5.3333333333333344e-001, 2.2207592200561263e-001, 1.1257411327720691e-002)
          },
          { # case 6
            n = c(6.1670659019259422e-001, 1.8891758777537109e+000, 3.3242574335521193e+000)
            w = c(4.0882846955602919e-001, 8.8615746041914523e-002, 2.5557844020562431e-003)
          },
          { # case 7
            n = c(0.0000000000000000e+000, 1.1544053947399682e+000, 2.3667594107345415e+000, 3.7504397177257425e+000)
            w = c(4.5714285714285757e-001, 2.4012317860501250e-001, 3.0757123967586491e-002, 5.4826885597221875e-004)
          },
          { # case 8
            n = c(5.3907981135137517e-001, 1.6365190424351082e+000, 2.8024858612875416e+000, 4.1445471861258945e+000)
            w = c(3.7301225767907736e-001, 1.1723990766175897e-001, 9.6352201207882630e-003, 1.1261453837536784e-004)
          },
          { # case 9
            n = c(0.0000000000000000e+000, 1.0232556637891326e+000, 2.0768479786778302e+000, 3.2054290028564703e+000, 4.5127458633997826e+000)
            w = c(4.0634920634920685e-001, 2.4409750289493909e-001, 4.9916406765217969e-002, 2.7891413212317675e-003, 2.2345844007746563e-005)
          },
          { # case 10
            n = c(4.8493570751549764e-001, 1.4659890943911582e+000, 2.4843258416389546e+000, 3.5818234835519269e+000, 4.8594628283323127e+000)
            w = c(3.4464233493201940e-001, 1.3548370298026730e-001, 1.9111580500770317e-002, 7.5807093431221972e-004, 4.3106526307183106e-006)
          },
          { # case 11
            n = c(0.0000000000000000e+000, 9.2886899738106388e-001, 1.8760350201548459e+000, 2.8651231606436447e+000, 3.9361666071299775e+000, 5.1880012243748714e+000)
            w = c(3.6940836940836957e-001, 2.4224029987397003e-001, 6.6138746071057644e-002, 6.7202852355372697e-003, 1.9567193027122324e-004, 8.1218497902149036e-007)
          },
          { # case 12
            n = c(4.4440300194413901e-001, 1.3403751971516167e+000, 2.2594644510007993e+000, 3.2237098287700974e+000, 4.2718258479322815e+000, 5.5009017044677480e+000)
            w = c(3.2166436151283007e-001, 1.4696704804532995e-001, 2.9116687912364138e-002, 2.2033806875331849e-003, 4.8371849225906076e-005, 1.4999271676371597e-007)
          },
          { # case 13
            n = c(0.0000000000000000e+000, 8.5667949351945005e-001, 1.7254183795882394e+000, 2.6206899734322149e+000, 3.5634443802816347e+000, 4.5913984489365207e+000, 5.8001672523865011e+000)
            w = c(3.4099234099234149e-001, 2.3787152296413588e-001, 7.9168955860450141e-002, 1.1770560505996543e-002, 6.8123635044292619e-004, 1.1526596527333885e-005, 2.7226276428059039e-008)
          },
          { # case 14
            n = c(4.1259045795460181e-001, 1.2426889554854643e+000, 2.0883447457019444e+000, 2.9630365798386675e+000, 3.8869245750597696e+000, 4.8969363973455646e+000, 6.0874095469012914e+000)
            w = c(3.0263462681301945e-001, 1.5408333984251366e-001, 3.8650108824253432e-002, 4.4289191069474066e-003, 2.0033955376074381e-004, 2.6609913440676334e-006, 4.8681612577483872e-009)
          },
          { # case 15
            n = c(0.0000000000000000e+000, 7.9912906832454811e-001, 1.6067100690287301e+000, 2.4324368270097581e+000, 3.2890824243987664e+000, 4.1962077112690155e+000, 5.1900935913047821e+000, 6.3639478888298378e+000)
            w = c(3.1825951825951820e-001, 2.3246229360973222e-001, 8.9417795399844444e-002, 1.7365774492137616e-002, 1.5673575035499571e-003, 5.6421464051890157e-005, 5.9754195979205961e-007, 8.5896498996331805e-010)
          },
          { # case 16
            n = c(3.8676060450055738e-001, 1.1638291005549648e+000, 1.9519803457163336e+000, 2.7602450476307019e+000, 3.6008736241715487e+000, 4.4929553025200120e+000, 5.4722257059493433e+000, 6.6308781983931295e+000)
            w = c(2.8656852123801241e-001, 1.5833837275094925e-001, 4.7284752354014067e-002, 7.2669376011847411e-003, 5.2598492657390979e-004, 1.5300032162487286e-005, 1.3094732162868203e-007, 1.4978147231618314e-010)
          },
          { # case 17
            n = c(0.0000000000000000e+000, 7.5184260070389630e-001, 1.5098833077967408e+000, 2.2810194402529889e+000, 3.0737971753281941e+000, 3.9000657171980104e+000, 4.7785315896299840e+000, 5.7444600786594071e+000, 6.8891224398953330e+000)
            w = c(2.9953837012660756e-001, 2.2670630846897877e-001, 9.7406371162718081e-002, 2.3086657025711152e-002, 2.8589460622846499e-003, 1.6849143155133945e-004, 4.0126794479798725e-006, 2.8080161179305783e-008, 2.5843149193749151e-011)
          },
          { # case 18
            n = c(3.6524575550769767e-001, 1.0983955180915013e+000, 1.8397799215086457e+000, 2.5958336889112403e+000, 3.3747365357780907e+000, 4.1880202316294044e+000, 5.0540726854427405e+000, 6.0077459113595975e+000, 7.1394648491464796e+000)
            w = c(2.7278323465428789e-001, 1.6068530389351263e-001, 5.4896632480222654e-002, 1.0516517751941352e-002, 1.0654847962916496e-003, 5.1798961441161962e-005, 1.0215523976369816e-006, 5.9054884788365484e-009, 4.4165887693587078e-012)
          },
          { # case 19
            n = c(0.0000000000000000e+000, 7.1208504404237993e-001, 1.4288766760783731e+000, 2.1555027613169351e+000, 2.8980512765157536e+000, 3.6644165474506383e+000, 4.4658726268310316e+000, 5.3205363773360386e+000, 6.2628911565132519e+000, 7.3825790240304316e+000)
            w = c(2.8377319275152108e-001, 2.2094171219914366e-001, 1.0360365727614400e-001, 2.8666691030118496e-002, 4.5072354203420355e-003, 3.7850210941426759e-004, 1.5351145954666744e-005, 2.5322200320928681e-007, 1.2203708484474786e-009, 7.4828300540572308e-013)
          },
          { # case 20
            n = c(3.4696415708135592e-001, 1.0429453488027509e+000, 1.7452473208141270e+000, 2.4586636111723679e+000, 3.1890148165533900e+000, 3.9439673506573163e+000, 4.7345813340460552e+000, 5.5787388058932015e+000, 6.5105901570136551e+000, 7.6190485416797591e+000)
            w = c(2.6079306344955544e-001, 1.6173933398400026e-001, 6.1506372063976029e-002, 1.3997837447101043e-002, 1.8301031310804918e-003, 1.2882627996192898e-004, 4.4021210902308646e-006, 6.1274902599829597e-008, 2.4820623623151838e-010, 1.2578006724379305e-013)
          },
          { # case 21
            n = c(0.0000000000000000e+000, 6.7804569244064405e-001, 1.3597658232112304e+000, 2.0491024682571628e+000, 2.7505929810523733e+000, 3.4698466904753764e+000, 4.2143439816884216e+000, 4.9949639447820253e+000, 5.8293820073044706e+000, 6.7514447187174609e+000, 7.8493828951138225e+000)
            w = c(2.7026018357287707e-001, 2.1533371569505982e-001, 1.0839228562641938e-001, 3.3952729786542839e-002, 6.4396970514087768e-003, 7.0804779548153736e-004, 4.2192347425515866e-005, 1.2253548361482522e-006, 1.4506612844930740e-008, 4.9753686041217464e-011, 2.0989912195656652e-014)
          },
          { # case 22
            n = c(3.3117931571527381e-001, 9.9516242227121554e-001, 1.6641248391179071e+000, 2.3417599962877080e+000, 3.0324042278316763e+000, 3.7414963502665177e+000, 4.4763619773108685e+000, 5.2477244337144251e+000, 6.0730749511228979e+000, 6.9859804240188152e+000, 8.0740299840217116e+000)
            w = c(2.5024359658693501e-001, 1.6190629341367538e-001, 6.7196311428889891e-002, 1.7569072880805774e-002, 2.8087610475772107e-003, 2.6228330325596416e-004, 1.3345977126808712e-005, 3.3198537498140043e-007, 3.3665141594582109e-009, 9.8413789823460105e-012, 3.4794606478771428e-015)
          },
          { # case 23
            n = c(0.0000000000000000e+000, 6.4847115353449580e-001, 1.2998764683039790e+000, 1.9573275529334242e+000, 2.6243236340591820e+000, 3.3050400217529652e+000, 4.0047753217333044e+000, 4.7307241974514733e+000, 5.4934739864717947e+000, 6.3103498544483996e+000, 7.2146594350518622e+000, 8.2933860274173536e+000)
            w = c(2.5850974080883904e-001, 2.0995966957754261e-001, 1.1207338260262091e-001, 3.8867183703480947e-002, 8.5796783914656640e-003, 1.1676286374978613e-003, 9.3408186090312983e-005, 4.0899772449921549e-006, 8.7750624838617161e-008, 7.6708888623999076e-010, 1.9229353115677913e-012, 5.7323831678020873e-016)
          },
          { # case 24
            n = c(3.1737009662945231e-001, 9.5342192293210926e-001, 1.5934804298164202e+000, 2.2404678516917524e+000, 2.8977286432233140e+000, 3.5693067640735610e+000, 4.2603836050199053e+000, 4.9780413746391208e+000, 5.7327471752512009e+000, 6.5416750050986341e+000, 7.4378906660216630e+000, 8.5078035191952583e+000)
            w = c(2.4087011554664056e-001, 1.6145951286700025e-001, 7.2069364017178436e-002, 2.1126344408967029e-002, 3.9766089291813113e-003, 4.6471871877939763e-004, 3.2095005652745989e-005, 1.2176597454425830e-006, 2.2674616734804651e-008, 1.7186649279648690e-010, 3.7149741527624159e-013, 9.3901936890419202e-017)
          },
          { # case 25
            n = c(0.0000000000000000e+000, 6.2246227918607611e-001, 1.2473119756167892e+000, 1.8770583699478387e+000, 2.5144733039522058e+000, 3.1627756793881927e+000, 3.8259005699724917e+000, 4.5089299229672850e+000, 5.2188480936442794e+000, 5.9660146906067020e+000, 6.7674649638097168e+000, 7.6560379553930762e+000, 8.7175976783995885e+000)
            w = c(2.4816935117648548e-001, 2.0485102565034041e-001, 1.1488092430395164e-001, 4.3379970167644971e-002, 1.0856755991462316e-002, 1.7578504052637961e-003, 1.7776690692652660e-004, 1.0672194905202536e-005, 3.5301525602454978e-007, 5.7380238688993763e-009, 3.7911500004771871e-011, 7.1021030370039253e-014, 1.5300389979986825e-017)
        }
    )   # end switch
    
    return( list( "nodes"     = n,
                  "weights"   = w ) )
}
