% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatCAR.R
\name{spatCAR}
\alias{spatCAR}
\title{Generate Spatial Random Fields from CAR Models}
\usage{
spatCAR(W, sig, rho)
}
\arguments{
\item{W}{Numeric matrix. The neighborhood matrix representing the adjacency relationships
between spatial units.
         It can be provided by using the function `rAdj`.}

\item{sig}{Numeric. The variance of the spatial random effects from the CAR model.
Must be positive.}

\item{rho}{Numeric. The spatial dependence parameter for the CAR model.
Must be between -1 and 1, inclusive.}
}
\value{
A numeric vector representing the spatial random field from the CAR model.
The length of the vector
        is equal to the number of spatial units (rows in the neighborhood matrix).
}
\description{
This function generates spatial random fields from Conditional Autoregressive (CAR) models
for lattice spatial data. Given a neighborhood matrix, a variance parameter, and a spatial
dependence parameter, the function produces a spatial random field.
}
\details{
The function starts by computing the diagonal matrix of the number of neighbors for each
 spatial unit.
Then, it calculates the precision matrix (Q) based on the given parameters and
neighborhood matrix.
A small constant (0.0001) is added to the diagonal to ensure the precision matrix is
non-singular.
Finally, the covariance matrix is calculated as the inverse of the precision matrix
multiplied by the variance parameter (`sig`).
The function uses multivariate normal random generation
(using `rmvnorm` from the `mvtnorm` package) to produce the spatial random field.
}
\examples{
# Generate a random adjacency matrix for 5 spatial regions with a probability of 0.2
W <- rAdj(n = 5, p = 0.2)

# Generate a spatial random field from the CAR model using the adjacency matrix
# with parameters variance = 0.1, and rho = 0.5
spatial_random_field <- spatCAR(W = W, sig = 0.1, rho = 0.5)
print(spatial_random_field)

}
