% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reilly.R
\name{rasterReilly}
\alias{rasterReilly}
\title{Create a Raster from a Reilly Regular Grid}
\usage{
rasterReilly(x, mask = NULL)
}
\arguments{
\item{x}{sp or sf object; output of the \code{reilly} function.}

\item{mask}{sp or sf object; this object is used to clip 
the raster. (optional)}
}
\value{
Raster of catchment areas values.
The raster uses a RAT (\code{\link[raster]{ratify}}) that contains the 
correspondance between raster values and catchement areas values. Use \code{
unique(levels(rasterName)[[1]])} to see the correpondance table.
}
\description{
This function creates a raster from a regularly spaced 
Reilly grid (output of the \code{\link{reilly}} function).
}
\examples{
library(raster)
data(hospital)
# Compute Reilly catchment areas from known points (hospital) on a
# grid defined by its resolution
myreilly <- reilly(knownpts = hospital, varname = "capacity",
                   typefct = "exponential", span = 1250, beta = 3,
                   resolution = 200, mask = paris, returnclass = "sf")
# Create a raster of reilly values
myreillyraster <- rasterReilly(x = myreilly, mask = paris)
plot(myreillyraster, col = rainbow(18))
# Correspondance between raster values and reilly areas
head(unique(levels(myreillyraster)[[1]]))
}
\seealso{
\link{reilly}, \link{plotReilly}.
}
