% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyme.svs.eco1.dat.R
\docType{data}
\name{lyme.svs.eco1.dat}
\alias{lyme.svs.eco1.dat}
\title{The Lyme disease dataset with Eco id=1}
\format{\describe{
  \item{\code{y}}{integer vector, output count, each element represents the disease count in one census tract.}
  \item{\code{X}}{Numeric matrix, matrix of covariates, includes percentage of developed land in each census tract, percentage of forest in each census tract, etc.}
  \item{\code{offset}}{Numeric vector, vector for offset values, each element represents the log of population divided by 20,000 in census tract.}
  \item{\code{location}}{Numeric matrix, location for each census tract.}
  \item{\code{geoid}}{Numeric vector, geo id for each census tract.}
}}
\usage{
lyme.svs.eco1.dat
}
\description{
The Lyme disease dataset contains case data from 2006 to 2011 demographic
data and land cover data in Virginia. Lyme disease case data were collected by Virginia Department of Health.
Eco id = 1 represents the southern/eastern subregion, which includes Piedmont, Middle Atlantic Coastal Plain, and Southeastern Plains.

The column names of X are listed as follows. The first column is the intercept column.

x1: Dvlpd_NLCD06; Percentage of developed land in each census tract

x2: Forest_NLCD06; Percentage of forest in each census tract

x3: Herbaceous_NLCD06; Percentage of herbaceous in each census tract

x4: X.Water_NLCD06; Percentage of water in each census tract

x5: Tract_Frag06; Sum of area of forested fragments in each census tract divided by the total area

x6: FragPerim06; Sum of forest fragment perimeters in each census tract divided by the total area

x7: CWED_DF06; CWED of developed-forest edge

x8: TECI_DF06; TECI of developed-forest edge

x9: CWED_FH06; CWED of forest-herbaceous edge

x10: TECI_FH06; TECI of forest-herbaceous edge

x11: CWED_HD06; CWED of herbaceous-developed edge

x12: TECI_HD06; TECI of herbaceous-developed edge

x13: Pop_den; Tract population density in 2010

x14: Median_age; Median age at each census tract in 2010

x15: Mean_income; Mean income (inflation adjusted) at each census tract in 2010


}

\references{
Xie, Y., Xu, L., Li, J., Deng, X., Hong, Y., Kolivras, K., and Gaines, D. N. (2018). Spatial Variable Selection and An Application to Virginia Lyme Disease Emergence. Preprint, arXiv:1809.06418 [stat.AP].
}

\examples{
data("lyme.svs.eco1")
lyme.svs.eco1.dat$dist=distmat.compute(location=lyme.svs.eco1.dat$location, dist.min=0.2821849)

}
\keyword{datasets}
