% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pwd}
\alias{pwd}
\title{Product Within Distance (Spatially Balanced Sampling Design)}
\usage{
pwd(dis, n, beta = 10, nrepl = 1L, niter = 10L)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far all the pairs
of units in the population are.}

\item{n}{Sample size.}

\item{beta}{Parameter \eqn{\beta} for the algorithm. The higher
\eqn{\beta} is, the more the sample is going to be spread (default = 10).}

\item{nrepl}{Number of samples to draw (default = 1).}

\item{niter}{Maximum number of iterations for the algorithm. More iterations are
better but require more time. Usually 10 is very efficient (default = 10).}
}
\value{
Returns a list with the following components:
\itemize{
\item \code{s}, a matrix \code{nrepl} x \code{n}, which contains the
\code{nrepl} selected samples, each of them stored in a row. In particular,
the i-th row contains all labels of units selected in the i-th sample.
\item \code{iterations}, number of iterations run by the algorithm.
}
}
\description{
Selects spatially balanced samples through the use of the
Product Within Distance design (PWD). To have constant inclusion
probabilities \eqn{\pi_{i}=n/N}, where \eqn{n} is sample size and
\eqn{N} is population size, the distance matrix has to be standardized with
function \code{\link{stprod}}.
}
\examples{
# Example 1
# Draw 1 sample of dimension 15 without constant inclusion probabilities
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
s <- pwd(dis = dis, n = 15)$s  # drawn sample
\donttest{
# Example 2
# Draw 1 sample of dimension 15 with constant inclusion probabilities
# equal to n/N, with N = population size
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
con <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(mat = dis, con = con) # standardized matrix
s <- pwd(dis = stand_dist$mat, n = 15)$s  # drawn sample

# Example 3
# Draw 2 samples of dimension 15 with constant inclusion probabilities
# equal to n/N, with N = population size, and an increased level of spread, beta = 20
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
con <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(mat = dis, con = con) # standardized matrix
s <- pwd(dis = stand_dist$mat, n = 15, beta = 20, nrepl = 2)$s  # drawn samples
}
}
\references{
Benedetti R, Piersimoni F (2017). A spatially balanced design with
probability function proportional to the within sample distance.
\emph{Biometrical Journal}, \strong{59}(5), 1067-1084.
\doi{10.1002/bimj.201600194}
}
