% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportUtils.R
\name{extractCohort}
\alias{extractCohort}
\title{Extract cohort from an age-period array}
\usage{
extractCohort(A, age = as.numeric(dimnames(A)[[1]][1]),
  period = as.numeric(dimnames(A)[[2]][1]), cohort = period - age)
}
\arguments{
\item{A}{an age-period array with a demographic quantity. This array 
can have two or more dimensions, with the first dimension being the age and 
the second dimension being the period (calendar year). Note that the names 
of these two dimension are taken to represent the possible ages and periods
in the array.}

\item{age}{optional age for defining the cohort to be extracted. If 
argument \code{age} is provided (and argument \code{cohort} is not) then the 
extracted cohort corresponds to those born in the year \code{period-age}.}

\item{period}{optional period (calendar year) for defining the cohort to be 
extracted. If argument \code{period} is provided (and argument \code{cohort} 
is not) then the extracted cohort corresponds to those born in the year 
\code{period-age}.}

\item{cohort}{optional cohort to be extracted. If this argument is provided
then arguments \code{age} and \code{period} are ignored.}
}
\value{
If the the input array is two dimensional the the output is a 
a vector with the quantity along the cohort. Otherwise if \code{A} is an 
N-dimensional  array the output is an (N-1)-dimensional array with the first 
dimension representing the cohort.
}
\description{
Extract cohorts from an age-period array. This is useful to
construct a life table or to perform actuarial/demographic 
calculations on a cohort basis using the output of several functions
in \code{StMoMo}.
}
\examples{
LCfit <- fit(lc(), data = EWMaleData, ages.fit = 55:89)
#Plot forecast mortality rates for the 1950 cohort
LCfor <- forecast(LCfit)
plot(55:61, extractCohort(fitted(LCfit, type = "rates"), cohort = 1950), 
     type = "l", log = "y", xlab = "age", ylab = "Mortality rate", 
     main = "Mortality rates for the 1950 cohort", 
     xlim = c(55,89), ylim = c(0.005, 0.12))
lines(62:89, extractCohort(LCfor$rates, cohort = 1950), lty = 2, col = "blue")


#Plot 10 simulated sets of mortality rates for the cohort 
# aged 60 in year 2010 (i.e., the 1950 cohort)
LCsim <- simulate(LCfit, nsim = 10)
mSim <- extractCohort(LCsim$rates, age = 60, period = 2010)
plot(55:61, extractCohort(fitted(LCfit, type = "rates"), cohort = 1950), 
     type = "l", log = "y", xlab = "age", ylab = "Mortality rate", 
     main = "Mortality rates for the 1950 cohort", 
     xlim = c(55,89), ylim = c(0.005, 0.12))
matlines(62:89, mSim, lty = 2)

}
\seealso{
\code{\link{fitted.fitStMoMo}}, \code{\link{forecast.fitStMoMo}},
\code{\link{simulate.fitStMoMo}}, \code{\link{simulate.bootStMoMo}}
}
