% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\name{defStormsList}
\alias{defStormsList}
\title{Creating a \code{stormsList} object}
\usage{
defStormsList(
  sds,
  loi,
  seasons = c(sds@seasons["min"], sds@seasons["max"]),
  names = NULL,
  maxDist = 300,
  scale = sshs,
  scalePalette = NULL,
  removeUnder = NULL,
  verbose = 2
)
}
\arguments{
\item{sds}{\code{stormsDataset} object.}

\item{loi}{Location of interest. Can be defined using,
\itemize{
\item character, a country name (e.g., "Vanuatu")
\item character, a basin name among "NA", "SA", "EP", "WP", "SP", "SI" and "NI"
\item numeric vector, a point coordinate (lon, lat in decimal degrees, e.g., c(169.5, -19.2))
\item sp (SpatialPolygon) or a sf (simple features) object (e.g., created from a shapefile)
}}

\item{seasons}{numeric vector. Seasons of occurrence of the storms (e.g., c(2020,2022)).
In the Southern Hemisphere, the cyclone season extends across two consecutive years.
Therefore, to capture the 2021 to 2022 cyclone season both years should be specified,
with cyclones assigned for the year that originated in. By default all storms from \code{sds} are extracted.}

\item{names}{character vector. Names of specific storms (in capital letters).}

\item{maxDist}{numeric. Maximum distance between the location of interest and the
storm for which track data are extracted. Default \code{maxDist} is set to 300 km.}

\item{scale}{numeric. List of storm scale thresholds used for the database.
Default value is set to the Saffir Simpson Hurricane Scale}

\item{scalePalette}{character. Named vector containing the color hex code
corresponding to each category interval of \code{scale} input}

\item{removeUnder}{numeric. Storms reaching this maximum level or less in the scale are removed.
Default value is set to NULL.}

\item{verbose}{numeric. Type of information the function displays. Can be:
\itemize{
\item \code{2}, information about both the processes and the outputs are displayed (default value),
\item \code{1}, only information about the processes are displayed, or
\item \code{0}, nothing is displayed.
}}
}
\value{
The \code{defStormsList()} function returns a \code{stormsList} object containing track data for all storms
meeting the specified criteria (e.g., name, season, location).
}
\description{
The \code{defStormsList()} function extracts storm track data from a \code{stormsDataset}
and creates a \code{stormsList} object based on specified arguments relating to location of interest,
seasons, and names of the storms.
}
\details{
The available countries for the \code{loi} are those provided in the
\code{rwolrdxtra} package. This package provide high resolution vector country
boundaries derived from Natural Earth data. More informations on the Natural Earth data
here: \href{https://www.naturalearthdata.com/downloads/10m-cultural-vectors/}{http://www.naturalearthdata.com/downloads/10m-cultural-vectors/}.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting data using country names
vanuatu.st <- defStormsList(sds = sds, loi = "Vanuatu")

#Getting data using a specific point location
pt <- c(169, -19)
pam.pt <- defStormsList(sds = sds, loi = pt, names = "PAM")

#Getting data using country and storm names
niran.nc <- defStormsList(sds = sds, loi = "New Caledonia", names = c("NIRAN"))

#Getting data using a user defined spatial polygon
poly <- cbind(c(135, 290, 290, 135, 135),c(-60, -60, 0, 0, -60))
sp <- sf::st_polygon(list(poly))
sp <- sf::st_sfc(sp, crs = 4326)
sp <- sf::st_as_sf(sp)
sts_sp <- defStormsList(sds = sds, loi = sp)

}
}
\references{
Knapp, K. R., Kruk, M. C., Levinson, D. H., Diamond, H. J., & Neumann, C. J. (2010).
The International Best Track Archive for Climate Stewardship (IBTrACS).
Bulletin of the American Meteorological Society, 91(3), Article 3.
\url{doi:10.1175/2009bams2755.1}
}
