% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-GET.R
\docType{methods}
\name{getSignals}
\alias{getSignals}
\alias{getSignals,Strategy-method}
\title{Get trading signals from \code{Strategy}-object}
\usage{
getSignals(object, from = NULL, until = NULL, which = NULL,
  use.backtest = FALSE)

\S4method{getSignals}{Strategy}(object, from = NULL, until = NULL,
  which = NULL, use.backtest = FALSE)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which signals shall be returned. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which signals shall be returned. If \code{NULL}, no restriction is made.}

\item{which}{Names or column-number of assets that should be returned. If \code{NULL}, all signals are returned.}

\item{use.backtest}{If set to \code{TRUE}, the signals of the backtest are returned. Requires \code{\link{backtest}} to be  executed first.}
}
\description{
Gets the trading signals of an object of class \code{Strategy} that were output from strategy calculation.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get signals from MA(200)-Strategy
# all signals returned
getSignals(myStrat.MA)
# backtest signals for first two assets returned
# getSignals(myStrat.MA, which=c(1,2), use.backtest=TRUE)

##End(Not run)
}
