% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profiler.R
\name{profiler}
\alias{profiler}
\title{Extract the profile of a litholog}
\usage{
profiler(log, gap, ext = Inf, down.xy = NA, up.xy = NA, warn = F)
}
\arguments{
\item{log}{a "litholog()"-like data frame}

\item{gap}{the most inward values of the profile, i.e. the minimum values
expected in the signal}

\item{ext}{the most outward values of the profile; defaults to infinity Inf,
for "left-side" profiles, set to -Inf}

\item{down.xy, up.xy}{the xy values to give the the lower and upper parts of
the signal.}

\item{warn}{whether to have a detailed explanation of problems with the
extraction of a profile. This is useful to diagnose strange outputs.}
}
\value{
a data frame of the extracted profile, with its i (bed
identification), dt (depth/time), and xy (intensity).
}
\description{
Extract the induration, grain-size, lithology, facies, or any
other information coded in the profile variations of a litholog.
}
\examples{
l <- c(1,2,3,4,5)  # left boundary of the bed interval (upper or lower)
r <- c(0,1,2,3,4)  # right boundary of the bed interval (upper or lower)
h <- c(4,3,4,2,3) # hardness (arbitrary)
i <- c("B1","B2","B3","B4","B5") # Bed name

log <- litholog(l,r,h,i) # Generate data frame of the polygons
                         # making the litholog

# Extract the profile of the litholog, with the upper and lower values set
# at a value of 2 ----

pro <- profiler(log, gap = 2, up.xy = 2, down.xy = 2)

opar <- par()$mfrow

par(mfrow = c(1,2))

# Draw the litholog ----

plot.new()
plot.window(xlim = c(0,4), ylim = c(0,5))

axis(1)
axis(2)

multigons(log$i, log$xy, log$dt,
          col = c("grey80","grey20","grey80","grey20","grey80")) # Draw log

# Draw the profile ----

plot(pro$xy, pro$dt, type = "l", xlab = "hardness", ylab = "", axes = FALSE)

axis(1)

par(mfrow = opar)

}
