% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master_function.R
\name{data.gen}
\alias{data.gen}
\title{data.gen}
\usage{
data.gen(
  n,
  k,
  prevalence = sqrt(0.5),
  prog.eff = 1,
  sig2,
  y.sig2,
  rho,
  rhos.bt.real,
  a.constent
)
}
\arguments{
\item{n}{Total sample size}

\item{k}{Number of markers}

\item{prevalence}{prevalence of predictive biomarkers with values above the cutoff}

\item{prog.eff}{effect size \eqn{beta} for prognostic biomarker}

\item{sig2}{standard deviation of each marker}

\item{y.sig2}{Standard Deviation of the error term in the linear component}

\item{rho}{rho*sig2 is the entries for covariance matrix between pairs of different k markers}

\item{rhos.bt.real}{correlation between each prognostic and predictive markers}

\item{a.constent}{a constant is set such that there is no overall treatment effect}
}
\value{
A list of simulated clinical trial data with heterogeneous prognostic and predictive biomarkers
}
\description{
Function for simulated data generation
}
\details{
Function for simulated data generation
}
\examples{
n <- 500
k <- 10
prevalence <- sqrt(0.5)
rho<-0.2
sig2 <- 2
rhos.bt.real <- c(0, rep(0.1, (k-3)))*sig2
y.sig2 <- 1
prog.eff <- 0.5
effect.size <- 1
a.constent <- effect.size/(2*(1-prevalence))
ObsData <- data.gen(n=n, k=k, prevalence=prevalence, prog.eff=prog.eff,
                    sig2=sig2, y.sig2=y.sig2, rho=rho,
                    rhos.bt.real=rhos.bt.real, a.constent=a.constent)
}
