% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FH_Boot.R
\name{mspe_FH_Boot}
\alias{mspe_FH_Boot}
\title{MSPE estimation in FH model using double-phase bootstrap method.Calculate the mspe of Fay-Herriot model in SAE using double-phase bootstrap method.}
\usage{
mspe_FH_Boot(m, p, X, beta, A, D, B1, B2, R)
}
\arguments{
\item{m}{number of small areas}

\item{p}{number of fixed model parameters}

\item{X}{covariates}

\item{beta}{regression coefficients}

\item{A}{variance of area-specific random effects}

\item{D}{sampling variance}

\item{B1}{number of first-phase bootstrap method}

\item{B2}{number of second-phase bootstrap method}

\item{R}{number of simulation runs}
}
\value{
Par: return estimation of model parameters

MSPE.TRUE.Final: return empirical MSPE of small area predictor

mspe.Boot1.Final: return mspe of small area predictor using the bootstrap method 1

mspe.Boot2.Final: return mspe of small area predictor using the bootstrap method 2

RB.Boot1: return relative bias (RB) of mspe of small area predictor using the bootstrap method 1

RB.Boot2: return relative bias (RB) of mspe of small area predictor using the bootstrap method 2
}
\description{
MSPE estimation in FH model using double-phase bootstrap method.Calculate the mspe of Fay-Herriot model in SAE using double-phase bootstrap method.
}
\examples{
mspe_FH_Boot(20,3,matrix(runif(60,0,1),nrow=20,byrow=TRUE),c(1,1,1),10,2.5,20,20,10)



}
