% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate.surv.R
\name{generate.surv}
\alias{generate.surv}
\title{Simulate survival endpoints data where censoring depends on missing covariates.}
\usage{
generate.surv(n, beta, phi, gamma, seed)
}
\arguments{
\item{n}{Sample Size.}

\item{beta}{Regression Coefficients for the event process (length of 3).}

\item{phi}{Regression Coefficients for the censoring process (length of 3).}

\item{gamma}{Regression Coefficients for the missingness (length of 3).}

\item{seed}{A random seed for data generation.}
}
\value{
A data frame with missing values. For the \code{delta} column, 0 = censored, and 1 = event.
}
\description{
We are assuming three covariates, two continuous and one binary,
where we assume the first continous and the binary covariates have missing values, and the second continuous covariates is fully observed.
}
\examples{
# Simulate a data set with approximately 50\% censoring
# and 50\% of the subjects with at least one missing covariates.
generate.surv(n = 100, beta = c(1,1,-1), phi= c(1,-1,-0.5), gamma = c(3,2,-1), seed = 112358)
}
