% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_lineup.R
\name{make_lineup}
\alias{make_lineup}
\title{Determine optimal entries against a given opponent lineup}
\usage{
make_lineup(
  df,
  op_df,
  point_values,
  result_col,
  events = NULL,
  max_entries = NULL,
  max_ind_entries = NULL
)
}
\arguments{
\item{df}{a data frame of times for the team to be entered.  Must contain
column \code{Event} with the same event naming convention as \code{op_df},
a column with name matching \code{result_col} containing times or diving
scores, and a column called \code{Name} containing athlete names}

\item{op_df}{a data frame containing the opponent lineup.  Must contain
column \code{Event} with the same event naming convention as \code{df},
a column with name matching \code{result_col} containing times or diving
scores, and a column called \code{Name} containing athlete names}

\item{point_values}{either a recognized string or a list of numeric values
containing the points awarded by place.  Recognized strings are
\code{"hs_four_lane"}, \code{"hs_six_lane"}, \code{"ncaa_six_lane"}}

\item{result_col}{the name of a column, present in both \code{df} and
\code{op_df} that contains times and/or diving scores}

\item{events}{a list of events.  If no list is entered then \code{events}
will be taken from \code{unique(op_df$Event)}}

\item{max_entries}{the number of entries a team is permitted per race.
usually half the number of lanes in the competition pool}

\item{max_ind_entries}{the number of indivdual events a given athlete may
enter}
}
\value{
a data frame of optimal entries based on \code{df} and \code{op_df}
}
\description{
Determine optimal entries against a given opponent lineup
}
