% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splash_clean_strings.R
\name{splash_clean_strings}
\alias{splash_clean_strings}
\title{Cleans input strings}
\usage{
splash_clean_strings(
  x,
  indent_length = Indent_Length,
  time_score_string = Time_Score_String,
  record_string = Record_String,
  header_string = Header_String,
  sponsorship_string = Sponsorship_String,
  reaction_string = Reaction_String,
  rule_string = Rule_String
)
}
\arguments{
\item{x}{a list of character strings}

\item{indent_length}{a numeric value denoting the number of spaces some
results are indented by.  \code{indent_length} is determined by
\code{splash_determine_indent_length}. Must be a whole number.}

\item{time_score_string}{a regex string for matching results (times and
scores) but not special strings like DQ}

\item{record_string}{a regex string for matching denoted records, rather than
results}

\item{header_string}{a regex string from matching splash headers/footers
included in result documents}

\item{sponsorship_string}{a regex string for matching sponsorship text within
result documents}

\item{reaction_string}{a regex string for matching reaction times}

\item{rule_string}{a regex string for matching rule text e.g. 'Rule 4.24'
that sometimes accompanies DQs}
}
\value{
returns a list of character strings that have been cleaned in
  preparation for parsing/sorting

  #' @seealso \code{splash_clean_strings} runs inside of
  \code{swim_parse_splash}
}
\description{
Cleans input from \code{read_results} is passed to \code{splash_swim_parse}
to remove unnneded characters and otherwise set it up for sorting.  Input is
in the form of character strings
}
