% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splash_determine_indent_length.R
\name{splash_determine_indent_length}
\alias{splash_determine_indent_length}
\title{Determines indent length for data within \code{swim_parse_splash}}
\usage{
splash_determine_indent_length(x, time_score_string)
}
\arguments{
\item{x}{output from \code{read_results} followed by \code{add_row_numbers}}

\item{time_score_string}{a regular expression as a string that describes
swimming times and diving scores}
}
\value{
returns a number indicating the number of spaces preceding an
  athlete's name in a tie row
}
\description{
In Splash results there are two line types that are of interest and don't
begin with either a place or a special string (DNS, DSQ etc.).  These are
ties and relays swimmers.  Relay swimmers are indented further than ties.
This function determines the number of spaces, called indent length, prior to
a tie row, plus a pad of four spaces.
}
\seealso{
\code{splash_determine_indent_length} runs inside of
  \code{swim_parse_splash}
}
