# devtools::test_active_file("tests/testthat/test-splash.R")

test_that("Glenmark Senior Nationals 2019 whole meet", {

  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/Glenmark_Senior_Nationals_2019.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse() %>%
    select(-Event)

  df_standard <-
    structure(list(Place = c("1", "2", "3", "4", "5", "6", "7", "8",
                             "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5",
                             "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2",
                             "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6", "7",
                             "8", "1", "2", "3", "4", "5", "6", "7", "1", "2", "3", "4", "5",
                             "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
                             "11", "12", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2",
                             "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6", "7",
                             "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4",
                             "5", "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "1",
                             "2", "3", "4", "5", "6", "7", "8", "9", "10", "1", "2", "3",
                             "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8",
                             "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5",
                             "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2",
                             "3", "4", "5", "6", "6", "8", "1", "2", "3", "4", "5", "6", "7",
                             "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4",
                             "5", "6", "7", "8", "9", "10", "1", "2", "3", "4", "5", "6",
                             "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3",
                             "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8",
                             "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5",
                             "6", "7", "8", "1", "2", "3", "4", "5", "1", "2", "3", "4", "5",
                             "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "9", "1",
                             "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6",
                             "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3",
                             "4", "5", "6", "7", NA, "1", "2", "3", "4", "5", "6", "7", "8",
                             "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5",
                             "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8"), Name = c("Kushagra Rawat",
                                                                                              "ANAND AS", "AARON FERNANDES", "Vishal Grewal", "Anurag R. Singh",
                                                                                              "Aneesh S Gowda", "Sushrut. S. Kapse", "ARUN DEV", "Shivani Kataria",
                                                                                              "Shivangi Sarma", "Khushi Dinesh", "Bhavika Dugar", "Bhavya Sachdeva",
                                                                                              "Shakthi B", "RUTUJA TALEGAONKAR", "Kanya Nayyar", "Sajan Prakash",
                                                                                              "Shrihari Nataraj", "Siva S", "Sanu Debnath", "ARVIND MANI",
                                                                                              "JAYANT M", "Sethu Manickavel T", "Nanak Moolchandani", "Richa Mishra",
                                                                                              "KENISHA GUPTA", "APEKSHA FERNANDES", "Shrungi Bandekar", "Soubrity Mondal",
                                                                                              "Meenakshi V K R", "Firdoush Kayamkhani", "Astha Choudhury",
                                                                                              "Likith S P", "Ansh Arora", "Danush S", "SHWEJAL MANKAR", "VAISHNAV HEGDE B",
                                                                                              "ASHISH TOKAS", "Harnimrat Singh Bhinder", "Suneesh. S", "Jayaveena A V",
                                                                                              "Chahat Arora", "Annie Jain", "Saloni Dalal", "KAREENA SHANKTA",
                                                                                              "Arushi Manjunath", "SHARON SHAJU", "Shriya Ishwar Prasad", NA,
                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "Kushagra Rawat",
                                                                                              "Sushrut. S. Kapse", "Aneesh S Gowda", "Anurag R. Singh", "Dhyan Balakrishna",
                                                                                              "SACHIN MAURYA", "ARUN DEV", "Saurabh Sangvekar", "Krishna Gadakh",
                                                                                              "DEV AMBOKAR", "SHUBHAM DHAYGUDE", "Sujan Chowdary P", "Richa Mishra",
                                                                                              "APEKSHA FERNANDES", "Shakthi B", "Shrungi Bandekar", "Firdoush Kayamkhani",
                                                                                              "Astha Choudhury", "Kanya Nayyar", "Kalyani Saxena", "Shrihari Nataraj",
                                                                                              "Siva S", "ARVIND MANI", "Anurag Dagar", "K. Abbasuddin", "Nanak Moolchandani",
                                                                                              "Soumyajit Saha", "Sethu Manickavel T", "Maana Patel", "Suvana C Baskar",
                                                                                              "Soubrity Mondal", "Meenakshi V K R", "YUGA BIRNALE", "Pratyasa Ray",
                                                                                              "Shreyanti Pan", "Shrungi Bandekar", "VIRDHAWAL KHADE", "Viraj Prabhu",
                                                                                              "MIHIR AMBRE", "Anshul Kothari", "ANAND AS", "Aaron D' Souza",
                                                                                              "GAURAV YADAV KA", "Samit Sejwal", NA, NA, NA, NA, NA, NA, NA,
                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, "Richa Mishra", "Bhavika Dugar",
                                                                                              "Khushi Dinesh", "Shakthi B", "Kanya Nayyar", "RUTUJA TALEGAONKAR",
                                                                                              "Navya Singal", "Divya Ghosh", "DOLLY PATIL", "Saachi Gramopadhye",
                                                                                              "Siva S", "T Emil Robin Singh", "JAYANT M", "Vishal Grewal",
                                                                                              "Yogeshwar Prasad", "Aneesh S Gowda", "Nanak Moolchandani", "Harshit Hooda",
                                                                                              "APEKSHA FERNANDES", "Saloni Dalal", "JYOTI PATIL", "Kalyani Saxena",
                                                                                              "Annie Jain", "Chahat Arora", "Saanvi S Rao", "Harshitha Jayaram",
                                                                                              "Likith S P", "Danush S", "M Lohith.", "ARUN S", "Oum Saxena",
                                                                                              "Tanish Kaswan", "AKASH POWAR", "Aditya Dubey", "Divya Satija",
                                                                                              "Nina Venkatesh", "JYOTSNA PANSARE", "Suvana C Baskar", "KENISHA GUPTA",
                                                                                              "Jayaveena A V", "Talasha Prabhu", "Avantika Chavan", "VIRDHAWAL KHADE",
                                                                                              "Supriya Mondal", "MIHIR AMBRE", "Aman Ghai", "Anshul Kothari",
                                                                                              "Viraj Prabhu", "Rakshith U shetty", "Tanish George Mathew",
                                                                                              "RUJUTA KHADE", "KENISHA GUPTA", "Avantika Chavan", "Aditi Dhumatkar",
                                                                                              "Mahi Swet Raj", "Jayaveena A V", "Talasha Prabhu", "Shivangi Sarma",
                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                              "Kushagra Rawat", "Soumyajit Saha", "Sushrut. S. Kapse", "Anurag R. Singh",
                                                                                              "Aneesh S Gowda", "SACHIN MAURYA", "Dhyan Balakrishna", "Gyan Sandhan Kashyap",
                                                                                              "Krishna Gadakh", "SHUBHAM DHAYGUDE", "Shivani Kataria", "KENISHA GUPTA",
                                                                                              "Khushi Dinesh", "Shivangi Sarma", "Bhavya Sachdeva", "Swarna K Harith",
                                                                                              "Navya Singal", "Smruthi Mahalingam", "Sajan Prakash", "MIHIR AMBRE",
                                                                                              "Supriya Mondal", "Tanish George Mathew", "Sanu Debnath", "SHIVAKSH SAHU",
                                                                                              "Bikram Changmai", "Priyank Rana", "Divya Satija", "APEKSHA FERNANDES",
                                                                                              "Nina Venkatesh", "Shivani Kataria", "Srishti Nag", "Damini K Gowda",
                                                                                              "Liyana Fathima Umer", "Uttara Gogoi", "Shrihari Nataraj", "Rakshith U shetty",
                                                                                              "MADHU P S", "Siddhant Sejwal", "ARVIND MANI", "Tanmay Das",
                                                                                              "Soumyajit Saha", "SHWEJAL MANKAR", "Maana Patel", "JYOTSNA PANSARE",
                                                                                              "Ridhima Veerendra Kumar", "Suvana C Baskar", "Meenakshi V K R",
                                                                                              "Shrungi Bandekar", "Pratyasa Ray", "Shreyanti Pan", "Shrihari Nataraj",
                                                                                              "ANAND AS", "VINAY SAHARAN", "AARON FERNANDES", "Viraj Prabhu",
                                                                                              "Anshul Kothari", "Vishal Grewal", "Prithvi M", NA, NA, NA, NA,
                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, "Richa Mishra", "Khushi Dinesh",
                                                                                              "Bhavya Sachdeva", "Bhavika Dugar", "RUTUJA TALEGAONKAR", "Navya Singal",
                                                                                              "Divya Ghosh", "DOLLY PATIL", "Saachi Gramopadhye", "Kushagra Rawat",
                                                                                              "ANAND AS", "AARON FERNANDES", "Sanu Debnath", "VINAY SAHARAN",
                                                                                              "Vishal Grewal", "Avinash Mani", "Gyan Sandhan Kashyap", "KAREENA SHANKTA",
                                                                                              "Saloni Dalal", "Chahat Arora", "Annie Jain", "Harshitha Jayaram",
                                                                                              "Saanvi S Rao", "Kalyani Saxena", "SHARON SHAJU", "Likith S P",
                                                                                              "Danush S", "M Lohith.", "Ansh Arora", "ASHISH TOKAS", "Suneesh. S",
                                                                                              "T Emil Robin Singh", "Tanish Kaswan", "Ridhima Veerendra Kumar",
                                                                                              "Suvana C Baskar", "Soubrity Mondal", "Shreyanti Pan", "Pratyasa Ray",
                                                                                              "YUGA BIRNALE", "Shrungi Bandekar", "Maana Patel", "Shrihari Nataraj",
                                                                                              "MADHU P S", "Rakshith U shetty", "Tanmay Das", "Siddhant Sejwal",
                                                                                              "Soumyajit Saha", "Sethu Manickavel T", "Nanak Moolchandani",
                                                                                              "APEKSHA FERNANDES", "Anvesha Girish", "Shakthi B", "Richa Mishra",
                                                                                              "Srishti Nag", "Hema", "Kanya Nayyar", "Vanshika Sharma", "Sajan Prakash",
                                                                                              "Supriya Mondal", "Tanish George Mathew", "Sanu Debnath", "SHIVAKSH SAHU",
                                                                                              "Vinayak Parihar", "Bikram Changmai", "Saif Chandan Ali Kamcheru Satish",
                                                                                              "KENISHA GUPTA", "Shivani Kataria", "SADHVI DHURI", "Avantika Chavan",
                                                                                              "Shivangi Sarma", "Mahi Swet Raj", "Divya Satija", "Smruthi Mahalingam"
                             ), Age = c("90", NA, NA, "90", NA, NA, NA, NA, "97", "02", NA,
                                        "01", "90", "05", NA, "04", NA, NA, NA, NA, NA, NA, "07", "00",
                                        NA, NA, NA, "03", NA, "06", NA, "04", NA, NA, "00", NA, NA, NA,
                                        "96", NA, "08", "97", "02", NA, NA, NA, NA, "06", NA, NA, NA,
                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "90", NA, NA,
                                        NA, NA, NA, NA, NA, "03", NA, NA, "02", NA, NA, "05", "03", NA,
                                        "04", "04", "01", NA, NA, NA, "90", NA, "00", NA, "07", "00",
                                        NA, NA, "06", NA, "02", NA, "03", NA, NA, NA, "89", NA, NA, NA,
                                        "90", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                        NA, NA, NA, "01", NA, "05", "04", NA, NA, NA, NA, "00", NA, NA,
                                        NA, "90", NA, NA, "00", "03", NA, NA, NA, "01", "02", "97", NA,
                                        NA, NA, "00", NA, NA, NA, NA, NA, "90", "96", NA, NA, NA, NA,
                                        "08", "93", NA, NA, NA, NA, NA, "89", NA, NA, NA, NA, NA, NA,
                                        NA, "03", "08", "93", "02", NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                        NA, NA, NA, NA, NA, NA, NA, "90", NA, NA, NA, NA, NA, NA, "04",
                                        "03", NA, "97", NA, NA, "02", "90", "04", NA, NA, NA, NA, NA,
                                        NA, NA, NA, "04", "90", "96", NA, NA, "97", "96", NA, NA, "04",
                                        NA, NA, NA, "90", NA, "90", NA, NA, "00", NA, NA, NA, "06", "03",
                                        "02", NA, NA, NA, NA, NA, NA, "89", "90", NA, NA, NA, NA, NA,
                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "90", "01", NA, NA,
                                        NA, NA, "00", "90", NA, NA, NA, NA, "90", NA, "04", NA, NA, "97",
                                        "02", NA, NA, "01", NA, NA, "00", NA, NA, NA, NA, NA, NA, NA,
                                        NA, NA, NA, "02", NA, "03", "00", NA, NA, NA, "90", "90", NA,
                                        "07", "00", NA, NA, "05", NA, "96", "90", "04", "90", NA, NA,
                                        NA, NA, NA, "90", "04", NA, NA, "97", NA, NA, "02", "03", "96",
                                        NA), Team = c("DELHI", "SSCB", "MAHARASHTRA", "DELHI", "UTTAR PRADESH",
                                                      "KARNATAKA", "R.S.P.B", "SSCB", "HARYANA", "ASSAM", "KARNATAKA",
                                                      "TAMILNADU", "DELHI", "TAMILNADU", "MAHARASHTRA", "M.P.", "POLICE",
                                                      "KARNATAKA", "KARNATAKA", "R.S.P.B", "SSCB", "SSCB", "TAMILNADU",
                                                      "M.P.", "POLICE", "MAHARASHTRA", "MAHARASHTRA", "GOA", "BENGAL",
                                                      "TAMILNADU", "RAJASTHAN", "ASSAM", "KARNATAKA", "UTTAR PRADESH",
                                                      "TAMILNADU", "MAHARASHTRA", "SSCB", "SSCB", "PUNJAB", "KERALA",
                                                      "TAMILNADU", "PUNJAB", "MADHYA PRADESH", "KARNATAKA", "MAHARASHTRA",
                                                      "KARNATAKA", "MAHARASHTRA", "TAMILNADU", "KARNATAKA", "SSCB",
                                                      "R.S.P.B", "POLICE", "BENGAL", "MAHARASHTRA", "KERALA", "KARNATAKA",
                                                      "MAHARASHTRA", "R.S.P.B", "GUJARAT", "TAMILNADU", "DELHI", "BENGAL",
                                                      "KERALA", "DELHI", "R.S.P.B", "KARNATAKA", "UTTAR PRADESH", "KARNATAKA",
                                                      "SSCB", "SSCB", "R.S.P.B", "MADHYA PRADESH", "MAHARASHTRA", "MAHARASHTRA",
                                                      "ANDHRA PRADESH", "POLICE", "MAHARASHTRA", "TAMILNADU", "GOA",
                                                      "RAJASTHAN", "ASSAM", "M.P.", "GUJARAT", "KARNATAKA", "KARNATAKA",
                                                      "SSCB", "DELHI", "R.S.P.B", "M.P.", "R.S.P.B", "TAMILNADU", "GUJARAT",
                                                      "KARNATAKA", "BENGAL", "TAMILNADU", "MAHARASHTRA", "ODISHA",
                                                      "R.S.P.B", "GOA", "MAHARASHTRA", "R.S.P.B", "MAHARASHTRA", "GUJARAT",
                                                      "SSCB", "R.S.P.B", "SSCB", "DELHI", "MAHARASHTRA", "KARNATAKA",
                                                      "TAMILNADU", "DELHI", "BENGAL", "KERALA", "GUJARAT", "PUNJAB",
                                                      "KARNATAKA", "SSCB", "MAHARASHTRA", "R.S.P.B", "DELHI", "BENGAL",
                                                      "KERALA", "TELANGANA", "POLICE", "TAMILNADU", "KARNATAKA", "TAMILNADU",
                                                      "MADHYA PRADESH", "MAHARASHTRA", "UTTAR PRADESH", "KARNATAKA",
                                                      "MAHARASHTRA", "GOA", "KARNATAKA", "R.S.P.B", "SSCB", "DELHI",
                                                      "UTTAR PRADESH", "KARNATAKA", "M.P.", "HARYANA", "MAHARASHTRA",
                                                      "KARNATAKA", "MAHARASHTRA", "GUJARAT", "M.P.", "PUNJAB", "KARNATAKA",
                                                      "R.S.P.B", "KARNATAKA", "TAMILNADU", "R.S.P.B", "SSCB", "GUJARAT",
                                                      "RAJASTHAN", "SSCB", "DELHI", "HARYANA", "KARNATAKA", "MAHARASHTRA",
                                                      "KARNATAKA", "MAHARASHTRA", "TAMILNADU", "GOA", "R.S.P.B", "MAHARASHTRA",
                                                      "R.S.P.B", "MAHARASHTRA", "POLICE", "GUJARAT", "R.S.P.B", "KARNATAKA",
                                                      "KARNATAKA", "MAHARASHTRA", "MAHARASHTRA", "R.S.P.B", "R.S.P.B",
                                                      "BIHAR", "TAMILNADU", "GOA", "ASSAM", "KARNATAKA", "SSCB", "R.S.P.B",
                                                      "DELHI", "KERALA", "MAHARASHTRA", "BENGAL", "POLICE", "MAHARASHTRA",
                                                      "KARNATAKA", "TAMILNADU", "GUJARAT", "BENGAL", "DELHI", "KERALA",
                                                      "PUNJAB", "DELHI", "R.S.P.B", "R.S.P.B", "UTTAR PRADESH", "KARNATAKA",
                                                      "SSCB", "KARNATAKA", "ASSAM", "MADHYA PRADESH", "MAHARASHTRA",
                                                      "HARYANA", "MAHARASHTRA", "KARNATAKA", "ASSAM", "DELHI", "TAMILNADU",
                                                      "UTTAR PRADESH", "KARNATAKA", "POLICE", "MAHARASHTRA", "R.S.P.B",
                                                      "KARNATAKA", "R.S.P.B", "SSCB", "ASSAM", "DELHI", "HARYANA",
                                                      "MAHARASHTRA", "KARNATAKA", "HARYANA", "CHHATTISGARH", "KARNATAKA",
                                                      "KERALA", "ASSAM", "KARNATAKA", "KARNATAKA", "SSCB", "DELHI",
                                                      "SSCB", "DELHI", "R.S.P.B", "MAHARASHTRA", "GUJARAT", "MAHARASHTRA",
                                                      "KARNATAKA", "KARNATAKA", "TAMILNADU", "GOA", "ODISHA", "R.S.P.B",
                                                      "KARNATAKA", "SSCB", "SSCB", "MAHARASHTRA", "R.S.P.B", "GUJARAT",
                                                      "DELHI", "KARNATAKA", "KARNATAKA", "MAHARASHTRA", "TAMILNADU",
                                                      "BENGAL", "KERALA", "MAHARASHTRA", "R.S.P.B", "KARNATAKA", "DELHI",
                                                      "KERALA", "TAMILNADU", "BENGAL", "GUJARAT", "POLICE", "KARNATAKA",
                                                      "DELHI", "TAMILNADU", "MAHARASHTRA", "UTTAR PRADESH", "KARNATAKA",
                                                      "MAHARASHTRA", "GOA", "DELHI", "SSCB", "MAHARASHTRA", "R.S.P.B",
                                                      "SSCB", "DELHI", "KARNATAKA", "ASSAM", "MAHARASHTRA", "KARNATAKA",
                                                      "PUNJAB", "MADHYA PRADESH", "R.S.P.B", "KARNATAKA", "GUJARAT",
                                                      "MAHARASHTRA", "KARNATAKA", "TAMILNADU", "R.S.P.B", "UTTAR PRADESH",
                                                      "SSCB", "KERALA", "R.S.P.B", "RAJASTHAN", "KARNATAKA", "KARNATAKA",
                                                      "BENGAL", "R.S.P.B", "ODISHA", "MAHARASHTRA", "GOA", "GUJARAT",
                                                      "KARNATAKA", "SSCB", "KARNATAKA", "DELHI", "DELHI", "R.S.P.B",
                                                      "TAMILNADU", "MADHYA PRADESH", "MAHARASHTRA", "KARNATAKA", "TAMILNADU",
                                                      "POLICE", "CHHATTISGARH", "DELHI", "M.P.", "DELHI", "POLICE",
                                                      "R.S.P.B", "KARNATAKA", "R.S.P.B", "SSCB", "DELHI", "ASSAM",
                                                      "KARNATAKA", "MAHARASHTRA", "HARYANA", "MAHARASHTRA", "R.S.P.B",
                                                      "ASSAM", "BIHAR", "HARYANA", "KARNATAKA"), Finals = c("3:56.95",
                                                                                                                 "4:01.92", "4:04.71", "4:07.44", "4:09.34", "4:09.54", "4:11.74",
                                                                                                                 "4:13.00", "4:27.31", "4:30.55", "4:30.80", "4:37.18", "4:37.54",
                                                                                                                 "4:39.96", "4:45.87", "4:47.12", "2:05.89", "2:06.46", "2:06.69",
                                                                                                                 "2:09.13", "2:12.15", "2:12.49", "2:17.91", "2:20.87", "2:24.70",
                                                                                                                 "2:25.31", "2:26.53", "2:26.85", "2:30.44", "2:31.59", "2:33.44",
                                                                                                                 "2:34.17", "28.54", "29.38", "29.57", "29.60", "29.65", "29.81",
                                                                                                                 "29.88", "30.49", "33.86", "34.01", "34.30", "35.24", "35.32",
                                                                                                                 "35.38", "35.76", "36.11", "7:46.04", "7:49.31", "7:53.52", "8:19.53",
                                                                                                                 "8:20.32", "8:24.45", "8:46.12", "1:50.65", "1:52.82", "1:54.00",
                                                                                                                 "1:55.67", "1:57.23", "2:00.50", "2:01.71", "2:01.90", "15:41.45",
                                                                                                                 "16:29.27", "16:32.28", "16:44.68", "16:48.24", "16:52.77", "16:54.74",
                                                                                                                 "17:15.02", "17:34.64", "17:51.79", "18:41.31", "19:29.56", "5:05.49",
                                                                                                                 "5:12.91", "5:13.19", "5:18.92", "5:20.02", "5:25.12", "5:25.88",
                                                                                                                 "5:28.83", "2:02.29", "2:07.11", "2:10.24", "2:10.28", "2:10.66",
                                                                                                                 "2:11.87", "2:11.91", "2:13.42", "2:21.74", "2:22.30", "2:23.55",
                                                                                                                 "2:27.87", "2:30.03", "2:30.52", "2:31.62", "2:35.44", "22.44",
                                                                                                                 "23.39", "23.76", "23.77", "23.83", "23.93", "24.10", "24.21",
                                                                                                                 "4:02.90", "4:09.88", "4:13.25", "4:14.84", "4:15.54", "4:29.80",
                                                                                                                 "4:31.50", "4:47.63", "3:30.45", "3:31.04", "3:31.17", "3:33.22",
                                                                                                                 "3:37.07", "3:43.67", "3:45.01", "4:02.50", "17:55.55", "17:57.67",
                                                                                                                 "17:58.14", "18:29.40", "18:41.29", "19:01.60", "19:04.82", "19:53.91",
                                                                                                                 "20:15.27", "21:40.84", "4:33.01", "4:36.68", "4:41.21", "4:44.65",
                                                                                                                 "4:55.98", "4:56.07", "4:58.41", "4:59.06", "2:41.89", "2:42.50",
                                                                                                                 "2:42.76", "2:46.09", "2:49.11", "2:50.79", "2:51.90", "2:53.88",
                                                                                                                 "2:18.61", "2:19.11", "2:19.94", "2:20.18", "2:24.60", "2:25.38",
                                                                                                                 "2:27.26", "2:27.75", "28.33", "28.43", "28.74", "29.05", "29.06",
                                                                                                                 "29.52", "29.91", "30.09", "24.19", "24.55", "24.78", "25.30",
                                                                                                                 "25.60", "25.67", "25.68", "25.99", "26.72", "26.90", "27.39",
                                                                                                                 "27.57", "27.60", "27.67", "27.67", "27.68", "3:48.83", "3:52.11",
                                                                                                                 "3:52.93", "4:01.27", "4:02.53", "4:04.46", "4:07.31", "4:39.37",
                                                                                                                 "4:33.10", "4:34.84", "4:39.49", "4:40.06", "4:41.20", "4:52.31",
                                                                                                                 "4:56.41", "5:32.06", "8:09.47", "8:32.01", "8:33.58", "8:33.87",
                                                                                                                 "8:42.12", "8:52.91", "8:54.76", "8:57.24", "9:16.13", "9:22.83",
                                                                                                                 "2:05.80", "2:07.94", "2:10.49", "2:10.99", "2:15.13", "2:16.83",
                                                                                                                 "2:18.52", "2:20.33", "54.25", "54.38", "54.47", "56.15", "56.42",
                                                                                                                 "57.03", "57.90", "58.13", "1:04.38", "1:05.53", "1:05.98", "1:06.35",
                                                                                                                 "1:06.53", "1:06.89", "1:07.26", "1:09.32", "25.58", "26.73",
                                                                                                                 "27.02", "27.13", "27.26", "27.31", "27.76", "28.03", "30.39",
                                                                                                                 "30.82", "30.87", "30.91", "31.91", "32.13", "32.32", "32.60",
                                                                                                                 "50.59", "51.49", "52.87", "52.92", "52.97", "53.54", "53.58",
                                                                                                                 "53.62", "9:04.86", "9:08.51", "9:09.18", "9:23.37", "9:56.91",
                                                                                                                 "1:39.69", "1:41.83", "1:41.92", "1:44.95", "1:47.70", "1:48.06",
                                                                                                                 "1:49.74", "1:50.08", "9:22.50", "9:24.81", "9:31.41", "9:47.27",
                                                                                                                 "9:49.61", "9:53.55", "10:20.97", "10:38.66", "10:43.53", "1:53.44",
                                                                                                                 "1:54.97", "1:55.71", "1:56.69", "1:57.75", "1:57.98", "1:59.14",
                                                                                                                 "2:00.39", "1:14.97", "1:15.89", "1:16.36", "1:16.58", "1:18.80",
                                                                                                                 "1:19.03", "1:19.59", "1:19.91", "1:02.69", "1:04.18", "1:05.08",
                                                                                                                 "1:05.12", "1:05.24", "1:06.41", "1:07.11", "1:07.13", "1:07.19",
                                                                                                                 "1:07.22", "1:07.41", "1:08.79", "1:09.56", "1:09.81", "1:10.05",
                                                                                                                 "1:05.35", "55.63", "58.30", "58.89", "59.01", "59.18", "59.37",
                                                                                                                 "59.80", "1:01.18", "2:23.17", "2:25.43", "2:25.78", "2:25.96",
                                                                                                                 "2:30.75", "2:31.81", "2:32.15", "2:34.32", "2:00.13", "2:03.41",
                                                                                                                 "2:04.23", "2:05.49", "2:08.39", "2:08.86", "2:09.40", "2:13.67",
                                                                                                                 "58.26", "59.21", "1:00.06", "1:00.14", "1:00.36", "1:00.42",
                                                                                                                 "1:00.93", "1:02.50"), Points = c("801", "752", "727", "703",
                                                                                                                                                   "687", "685", "668", "658", "692", "667", "665", "620", "618",
                                                                                                                                                   "602", "565", "558", "742", "732", "728", "688", "641", "637",
                                                                                                                                                   "564", "529", "662", "653", "637", "633", "589", "575", "555",
                                                                                                                                                   "547", "751", "689", "675", "673", "670", "659", "655", "616",
                                                                                                                                                   "654", "645", "629", "580", "576", "573", "555", "539", "724",
                                                                                                                                                   "709", "690", "588", "585", "571", "503", NA, NA, NA, NA, NA,
                                                                                                                                                   NA, NA, NA, "791", "682", "676", "651", "644", "636", "632",
                                                                                                                                                   "595", "563", "536", "468", "413", "662", "616", "615", "582",
                                                                                                                                                   "576", "549", "546", "531", "766", "682", "634", "634", "628",
                                                                                                                                                   "611", "610", "590", "670", "662", "645", "590", "565", "559",
                                                                                                                                                   "547", "508", "809", "714", "681", "680", "675", "667", "653",
                                                                                                                                                   "644", "646", "593", "570", "559", "555", "471", "463", "389",
                                                                                                                                                   "715", "709", "708", "688", "652", "596", "585", "467", "626",
                                                                                                                                                   "623", "622", "571", "553", "524", "519", "458", "434", "354",
                                                                                                                                                   "712", "684", "651", "628", "559", "558", "545", "542", "634",
                                                                                                                                                   "627", "624", "587", "556", "540", "529", "512", "763", "754",
                                                                                                                                                   "741", "737", "672", "661", "636", "630", "641", "634", "614",
                                                                                                                                                   "594", "594", "566", "544", "535", "780", "746", "725", "682",
                                                                                                                                                   "658", "652", "652", "629", "695", "681", "645", "632", "630",
                                                                                                                                                   "625", "625", "625", "743", "712", "704", "634", "624", "609",
                                                                                                                                                   "588", "408", "609", "597", "568", "565", "558", "497", "476",
                                                                                                                                                   "339", "788", "688", "682", "681", "649", "610", "604", "596",
                                                                                                                                                   "537", "518", "724", "688", "649", "641", "584", "562", "542",
                                                                                                                                                   "521", "774", "768", "765", "698", "688", "666", "637", "629",
                                                                                                                                                   "639", "606", "594", "584", "579", "570", "561", "512", "825",
                                                                                                                                                   "723", "700", "692", "682", "678", "646", "627", "705", "676",
                                                                                                                                                   "673", "670", "609", "597", "586", "571", "797", "756", "698",
                                                                                                                                                   "696", "694", "672", "671", "669", "609", "597", "595", "551",
                                                                                                                                                   "463", NA, NA, NA, NA, NA, NA, NA, NA, "640", "632", "610", "562",
                                                                                                                                                   "555", "544", "475", "437", "427", "726", "698", "684", "667",
                                                                                                                                                   "650", "646", "627", "608", "625", "603", "592", "587", "539",
                                                                                                                                                   "534", "523", "516", "755", "704", "675", "674", "670", "635",
                                                                                                                                                   "615", "615", "643", "642", "636", "599", "579", "573", "567",
                                                                                                                                                   NA, "809", "703", "682", "678", "672", "666", "651", "608", "615",
                                                                                                                                                   "587", "583", "581", "527", "516", "513", "491", "799", "737",
                                                                                                                                                   "723", "701", "655", "648", "639", "580", "699", "666", "638",
                                                                                                                                                   "635", "628", "626", "611", "566"), DQ = c(0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                              0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)), row.names = c(NA,
                                                                                                                                                                                                                                                                          -341L), class = "data.frame")


      expect_equivalent(df_test, df_standard)

})

test_that("Khelo India Youth Games 2020 whole meet, has a tie, fully checked", {

  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/Khelo_India_Youth_Games_2020.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse() %>%
    select(-Event)

  df_standard <-
    structure(list(Place = c("1", "2", "3", "4", "5", "6", "7", "8",
                             "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5",
                             "6", "1", "2", "3", "4", "5", "1", "2", "3", "4", "5", "6", "7",
                             "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4",
                             "5", "6", "1", "2", "3", "4", "1", "2", "3", "4", "5", "5", "7",
                             "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4",
                             "5", "6", "7", "8", "1", "2", "3", "4", "5", "1", "2", "3", "4",
                             "5", "6", "7", "8", "9", "10", "1", "2", "3", "4", "5"), Name = c("SAMBHAVV R",
                                                                                               "ANEESH GOWDA S", "VEER KHATKAR", "VEDANT BAPNA", "GYAN SANDHAN KASHYAP",
                                                                                               "RAJDEEP GOGOI", "KRISHNA GADAKH", "BIKRAM CHANGMAI", "KHUSHI DINESH",
                                                                                               "KIARA BANGERA", "BHAVYA SACHDEVA", "SWARNA HARITH", "JHANVI CHOUDHARY",
                                                                                               "PALAK DHAMI", "MAHI SHWET RAJ", "ASHMITA CHANDRA", "AARON FERNANDES",
                                                                                               "SANJAY C J", "ANURAG SINGH", "RUNDRANSH MISHRA", "RUDRAKSH SAHU",
                                                                                               "JOY BARUA", "SHIVANGI SARMA", "BHAVIKA DUGAR", "JASMINE GURUNG",
                                                                                               "SAACHI GRAMOPAHYAY", "KIRAN SHET NARIYEKAR", "SWADESH MONDAL",
                                                                                               "ROHITH BENEDICTON", "BHARGAV PHUKAN", "SHRISH MAULIK", "AINESH RAY",
                                                                                               "YASH GULHANE", "JASHUA THOMAS", "DISHANT MEHTA", "KAREENA SHANKTA",
                                                                                               "APEKSHA FERNANDES", "ZARA JABBAR", "ARUSHI MANJUNATH", "ANVITA GOWDA",
                                                                                               "GUNN MATTA", "SHRIYA ISHWARPRASAD", "KHUSHPREET KAUR BHULLAR",
                                                                                               "DANUSH S", "M LOHITH", "VARUN PATEL", "MILANTON DUTTA", "SREEDIP MONDAL",
                                                                                               "R SUBRAMANIYAM", "KALYANI SAXENA", "AALIYAH SINGH", "RAJESHREE BURAGOHAIN",
                                                                                               "POOJA D", "ARYAN VARNEKAR", "HARSH SAROHA", "BIKRAM CHANGMAI",
                                                                                               "S HITEN MITTAL", "SAHIL LASKAR", "ANSHAV JINDAL", "ROHITH BENEDICTON",
                                                                                               "LAKSH PURI", "NINA VENKATESH", "KENISHA GUPTA", "NILABJAA GHOSH",
                                                                                               "SANJITI SAHA", "DISHA BHANDARI", "THITHIKSHAA H", "AEKA CHAKRA",
                                                                                               "MITHIKA KARAPURKAR", "MIHIR AMBRE", "D ADHITHYA", "PRIYANK RANA",
                                                                                               "M JAYA VIKESH", "ACHINTYA GHOSHAL", "RUDRAKSH SAHU", "SHUBHRANSHU DUTTA",
                                                                                               "A MIDHUNAN", "SUNAINA MANJUNATH", "SUMAN PATIL", "ANUBHUTI BARUAH",
                                                                                               "SUCHETNA CHAKRABORTY", "DOLPHI SARANG", "KHUSHI DINESH", "BHAVYA SACHDEVA",
                                                                                               "KIARA BANGERA", "AASTHA CHOUDHURY", "V VARSHA", "DIVYA GHOSH",
                                                                                               "KANYA NAYYAR", "CYNTHIA CHOUDHARY", "ASHMITA CHANDRA", "NIVRITI DATTA",
                                                                                               "SHIVANGI SARMA", "BHAVIKA DUGAR", "JASMINE GURUNG", "MOUMITRA KARAR",
                                                                                               "SAACHI GRAMOPAHYAY"), Age = c("04", "04", "04", "03", "04",
                                                                                                                              "04", "03", "04", "03", "06", "05", "04", "04", "05", "03", "05",
                                                                                                                              "00", "02", "02", "02", "02", "01", "02", "01", "00", "00", "00",
                                                                                                                              "04", "03", "04", "04", "03", "03", "05", "03", "04", "05", "05",
                                                                                                                              "04", "06", "04", "06", "04", "00", "01", "00", "01", "02", "00",
                                                                                                                              "00", "02", "02", "01", "04", "04", "04", "03", "05", "05", "03",
                                                                                                                              "03", "05", "03", "05", "05", "04", "05", "04", "04", "00", "02",
                                                                                                                              "99", "02", "02", "02", "01", "02", "02", "00", "02", "02", "01",
                                                                                                                              "03", "05", "06", "04", "03", "04", "04", "06", "05", "04", "02",
                                                                                                                              "01", "00", "01", "00"), Team = c("KARNATAKA", "KARNATAKA", "HARYANA",
                                                                                                                                                                "MAHARASHTRA", "DELHI", "ASSAM", "MADHYA PRADESH", "DELHI", "KARNATAKA",
                                                                                                                                                                "MAHARASHTRA", "DELHI", "TAMILNADU", "DELHI", "MAHARASHTRA",
                                                                                                                                                                "BIHAR", "KARNATAKA", "MAHARASHTRA", "KARNATAKA", "DELHI", "MAHARASHTRA",
                                                                                                                                                                "CHHATTISGARH", "ASSAM", "ASSAM", "TAMILNADU", "HARYANA", "GOA",
                                                                                                                                                                "GOA", "WEST BENGAL", "TAMILNADU", "DELHI", "MAHARASHTRA", "KARNATAKA",
                                                                                                                                                                "MAHARASHTRA", "TAMILNADU", "GUJARAT", "MAHARASHTRA", "MAHARASHTRA",
                                                                                                                                                                "MAHARASHTRA", "KARNATAKA", "KARNATAKA", "KARNATAKA", "TAMILNADU",
                                                                                                                                                                "MADHYA PRADESH", "TAMILNADU", "A.P.", "MADHYA PRADESH", "ASSAM",
                                                                                                                                                                "WEST BENGAL", "PUDUCHERRY", "GUJARAT", "UTTAR PRADESH", "ASSAM",
                                                                                                                                                                "PUDUCHERRY", "DELHI", "HARYANA", "DELHI", "KARNATAKA", "WEST BENGAL",
                                                                                                                                                                "PUNJAB", "TAMILNADU", "MAHARASHTRA", "KARNATAKA", "MAHARASHTRA",
                                                                                                                                                                "WEST BENGAL", "MAHARASHTRA", "UTTAR PRADESH", "KARNATAKA", "MAHARASHTRA",
                                                                                                                                                                "GOA", "MAHARASHTRA", "TAMILNADU", "DELHI", "TAMILNADU", "DELHI",
                                                                                                                                                                "CHHATTISGARH", "ASSAM", "PUDUCHERRY", "KARNATAKA", "GOA", "ASSAM",
                                                                                                                                                                "WEST BENGAL", "GUJARAT", "KARNATAKA", "DELHI", "MAHARASHTRA",
                                                                                                                                                                "DELHI", "TAMILNADU", "KARNATAKA", "MADHYA PRADESH", "GOA", "KARNATAKA",
                                                                                                                                                                "ASSAM", "ASSAM", "TAMILNADU", "HARYANA", "WEST BENGAL", "GOA"
                                                                                                                              ), Finals = c("1:56.66", "1:57.46", "1:58.61", "1:58.88",
                                                                                                                                                 "1:59.06", "2:03.50", "2:03.52", "2:10.99", "2:10.29", "2:12.16",
                                                                                                                                                 "2:12.66", "2:13.21", "2:13.48", "2:16.52", "2:17.87", "2:18.09",
                                                                                                                                                 "1:56.51", "1:56.95", "1:58.37", "1:58.70", "2:05.01", "2:10.96",
                                                                                                                                                 "2:07.91", "2:22.97", "2:24.30", "2:35.28", "2:38.32", "1:06.33",
                                                                                                                                                 "1:08.56", "1:08.90", "1:09.75", "1:10.01", "1:10.83", "1:11.67",
                                                                                                                                                 "1:11.88", "1:14.66", "1:15.47", "1:19.02", "1:19.62", "1:20.71",
                                                                                                                                                 "1:20.90", "1:21.12", "1:21.57", "1:03.71", "1:05.31", "1:08.51",
                                                                                                                                                 "1:08.91", "1:10.24", "1:22.15", "1:20.25", "1:22.18", "1:30.76",
                                                                                                                                                 "1:57.40", "25.70", "25.88", "25.92", "26.19", "26.75", "26.75",
                                                                                                                                                 "26.95", "27.21", "28.58", "28.96", "30.01", "30.46", "30.64",
                                                                                                                                                 "31.08", "31.15", "31.31", "25.00", "26.03", "26.46", "26.64",
                                                                                                                                                 "26.96", "26.97", "27.43", "33.34", "30.78", "31.07", "31.11",
                                                                                                                                                 "31.22", "31.33", "9:26.19", "9:30.06", "9:36.02", "9:44.29",
                                                                                                                                                 "9:49.70", "9:53.19", "9:57.08", "10:05.72", "10:19.83", "11:33.67",
                                                                                                                                                 "9:31.22", "10:13.78", "10:36.19", "11:17.24", "11:31.89"), DQ = c(0,
                                                                                                                                                                                                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)), row.names = c(NA, -97L), class = "data.frame")

  expect_equivalent(df_test, df_standard)

})

test_that("2012 Euro Juniors", {
  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/European_Jr_Champs_2012.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse() %>%
    select(-Event)

  place_sum <- sum(as.numeric(df_test$Place), na.rm = TRUE)
  dq_sum <- sum(df_test$DQ, na.rm = TRUE)


  expect_equivalent(place_sum, 33438)
  expect_equivalent(dq_sum, 46)

})
#
# test_that("2013 Euro Juniors, full meet checked", {
#   skip_on_cran()
#
#   # as of 3/18/23 pdf_test is not reading in rows where team names run into times correctly
#   # I don't know how to fix this beyond using typo/replacement
#
#   file <-
#     "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/Arena_European_Junior_Swimming_Champs_2013.pdf"
#
#   df_test <- file %>%
#     read_results() %>%
#     swim_parse() %>%
#     select(-Event)
#
#   df_standard <-
#     structure(list(Place = c("1", "2", "3", "4", "5", "6", "7", "7",
#                              "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19",
#                              "20", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "1",
#                              "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
#                              "14", "15", "16", "17", "18", "19", "20", "1", "2", "3", "4",
#                              "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
#                              "16", "17", "18", "19", "20", "1", "2", "3", "4", "5", "6", "7",
#                              "8", "8", "10", "11", "12", "13", "14", "15", "16", "17", "18",
#                              "19", "20", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
#                              "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12",
#                              "13", "14", "15", "16", "17", "18", "19", "20", "21", "1", "2",
#                              "3", "4", "5", "6", "6", "8", "9", "10", "1", "2", "3", "4",
#                              "5", "6", "7", "8", "9", "10", "1", "2", "3", "4", "5", "6",
#                              "7", "8", "9", "10", "1", "2", "3", "4", "5", "6", "7", "8",
#                              "9", "10", "1", "2", "3", "4", "5", "6", "7", "8", "9", NA),
#                    Name = c("STOLK Kyle", "WESTERMANN Magnus", "HOLUB Jan",
#                             "SZCZEPANSKI Sebastian", "SEDOV Evgeny", "HANSEN Morten Bak",
#                             "NIKULIN Iaroslav", "WIERLING Damian", "MYLONAS Fotios",
#                             "DEOLET Timothy", "HOLODA Peter", "SMITH Jack", "BROGLIA Alessandro",
#                             "PLAVIN Bogdan", "SORIC Lovre", "AYAR Kaan Tuerker", "HALDEMANN Alexandre",
#                             "NAGY Marcel", "NASCIMENTO Miguel Duarte", "ROGOZIN Jevgenij",
#                             "BECK Leonie Antonia", "KISS Nikoletta", "CAPONI Linda",
#                             "MASSONE Antonia", "SALAMATINA Valeria", "JONES Ellena",
#                             "VOLKODAVOVA Polina", "TETTAMANZI Alisia", "NATLACEN Gaja",
#                             "PEREZ BLANCO Jimena", "KUDASHEV Alexander", "TERRES ILLESCAS Pedro",
#                             "GRATZ Benjamin", "TWAROWSKI Jerzy", "JOHNSON Matthew", "SZABO Norbert",
#                             "KUNERT Alexander", "MUGNAINI Mattia", "KUSWIK Maciej", "RIVAS GALLEGO Javier",
#                             "GUREVICH Etay", "LIESS Nils", "KRYPAK MaksyM", "NOVAK Petr",
#                             "O'SULLIVAN David", "DIMITROV Nikola", "VATASESCU Stefan Andrei",
#                             "HECLAU Tom", "MARGEVICIUS Deividas", "WURZER Stefan", "SOLNTSEVA Viktoriya",
#                             "GUERRA Silvia", "MALYAVINA Anastasiya", "SEBESTYEN Dalma",
#                             "HUETHER Marlene", "KAZINA Polina", "REISAENEN Sofie", "HUMMEL Margarethe",
#                             "KAENSAEKOSKI Silja", "STEPANOVA Monika", "MIKKELBORG Silje",
#                             "HANSSON Sophie", "PINTAR Tjasa", "NABNEY Erin", "KADOGLU Georgiya",
#                             "MC NAMARA Dearbhail", "WIKIEL Angelika", "LEMKE Julia",
#                             "BAZYL Magdalena", "ELORANTA Emilia", "MAKOVICH Semen", "LITCHFIELD Max",
#                             "CHATRON Cyril", "CWIEK Kacper", "SZARANEK Mark", "STRAZDAS Povilas",
#                             "TAROCCHI Lorenzo", "ORNEK Alpkan", "SANCHEZ GTREZ-CABELLO",
#                             "MASLOV Andrey", "FOLDHAZI David", "CARAZO BARBERO Gonzalo",
#                             "BAIONI Andrea", "THOMASBERGER David", "SERES Edwin", "GREVEN Lucas",
#                             "STEPIEN Konrad", "VELOSO Tomas Miguel", "CHAIKOU Pavel",
#                             "FODOR Bogdan", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "MICKA Jan",
#                             "FURTEK Pawel", "HUGHES Caleb", "WOJDAK Wojciech", "BOUCHAUT Joris",
#                             "BOCK Maximilian", "ROMANCHUK Mykhaylo", "KNIGHT Joel", "CHRISTIANSEN Henrik",
#                             "BRZOSKOWSKI Maarten", "PIIROINEN Eetu", "SAEMUNDSSON Sven Arnar",
#                             "ACERENZA Domenico", "GIBBONS Brendan", "DMYTRIYEV Roman",
#                             "BJOERLYKKE Ole Martin", "MORTENSEN Oli", "SUHAREV Petar",
#                             "CHERNEV Teodosi", "HJELM Alvi", "FARKAS Tamas", "BAKLAKOVA Maria",
#                             "GALLARDO CARAPETO Fatima", "MEYNEN Julie-Marie", "SCHOLTISSEK Helen",
#                             "GOVEJSEK Nastja", "COOPER Harriet", "LEVISEN Julie", "HACHE Cloe",
#                             "KLEIN Nele", "LATHAM Katie", "GUZHENKOVA Anastasia", "DAY Emma",
#                             "SEBESTYEN Dalma", "WATTEL Marie", "NOVOSZATH Melinda", "RICO PEREZ Carmen",
#                             "AUSTIN Shauntelle", "PODEUS Elin", "KAETHNER Rosalie", "BENESOVA Alena",
#                             "TARASEVICH Grigory", "RAPSYS Danas", "SABBIONI Simone",
#                             "SCHWARZ Carl-Louis", "CHRISTOU Apostolos", "KONTIZAS Michail",
#                             "NASCIMENTO Miguel Duarte", "FOLDHAZI David", "THEODORIS Nathan",
#                             "MENCARINI Luca", "DORINOV Mikhail", "PALATOV Alexander",
#                             "LINDENBERG Yannick", "HORVATH David", "PILGER Max", "AURUSKEVICIUS Mantas",
#                             "ACKLAND Harry", "CALLAIS Quentin", "PFYFFER Luca", "NACHTMAN Mateusz",
#                             "OEZTUERK Sonnele", "MAZUTAITYTE Ugne", "RIEDEMANN Laura",
#                             "BRIGGS Megan", "GRUSOVA Tereza", "ZAMORANO SANZ Africa",
#                             "SVECENA Lucie", "MAGNER Agata", "HOPE Lucy", "USTINOVA Daria K"
#                    ), Age = c("96", "95", "96", "95", "96", "95", "95", "96",
#                               "96", "95", "96", "96", "96", "95", "95", "95", "95", "95",
#                               "95", "96", "97", "97", "98", "97", "98", "97", "98", "97",
#                               "97", "97", "95", "95", "96", "95", "95", "96", "96", "95",
#                               "96", "95", "95", "96", "95", "96", "95", "95", "95", "95",
#                               "95", "95", "98", "97", "97", "97", "98", "97", "97", "97",
#                               "97", "97", "98", "98", "97", "97", "98", "98", "98", "98",
#                               "97", "97", "95", "95", "95", "95", "95", "96", "95", "95",
#                               "96", "95", "95", "96", "95", "96", "95", "95", "96", "96",
#                               "96", "95", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "95",
#                               "95", "95", "96", "95", "95", "96", "95", "96", "95", "95",
#                               "96", "95", "95", "95", "96", "96", "95", "96", "96", "95",
#                               "97", "97", "97", "97", "97", "97", "97", "97", "98", "97",
#                               "97", "97", "97", "97", "98", "98", "97", "97", "97", "98",
#                               "95", "95", "96", "95", "96", "95", "95", "95", "95", "95",
#                               "95", "95", "95", "96", "96", "95", "96", "96", "96", "95",
#                               "98", "97", "98", "97", "98", "98", "97", "97", "97", "98"
#                    ), Team = c("Netherlands", "Denmark", "Poland", "Poland",
#                                "Russia", "Denmark", "Russia", "Germany", "Greece", "Belgium",
#                                "Hungary", "Great Britain", "Italy", "Ukraine", "Croatia",
#                                "Turkey", "Switzerland", "Germany", "Portugal", "Lithuania",
#                                "Germany", "Hungary", "Italy", "Germany", "Russia", "Great Britain",
#                                "Russia", "Italy", "Slovenia", "Spain", "Russia", "Spain",
#                                "Hungary", "Poland", "Great Britain", "Hungary", "Germany",
#                                "Italy", "Poland", "Spain", "Israel", "Switzerland", "Ukraine",
#                                "Czech Republic", "Ireland", "Bulgaria", "Romania", "Germany",
#                                "Lithuania", "Austria", "Ukraine", "Italy", "Ukraine", "Hungary",
#                                "Germany", "Russia", "Norway", "Germany", "Finland", "Czech Republic",
#                                "Norway", "Sweden", "Slovenia", "Great Britain", "Bulgaria",
#                                "Ireland", "Poland", "Belarus", "Poland", "Finland", "Russia",
#                                "Great Britain", "France", "Poland", "Great Britain", "Lithuania",
#                                "Italy", "Turkey", "Spain", "Russia", "Hungary", "Spain",
#                                "Italy", "Germany", "Hungary", "Netherlands", "Poland", "Portugal",
#                                "Belarus", "Romania", "Russia", "Great Britain", "Germany",
#                                "Poland", "Denmark", "France", "Croatia", "Austria", "Switzerland",
#                                "Finland", "Czech Republic", "Poland", "Great Britain", "Poland",
#                                "France", "Germany", "Ukraine", "Great Britain", "Norway",
#                                "Netherlands", "Finland", "Croatia", "Italy", "Ireland",
#                                "Czech Republic", "Norway", "Faroe Islands", "Bulgaria",
#                                "Bulgaria", "Faroe Islands", "Serbia", "Russia", "Spain",
#                                "Luxembourg", "Germany", "Slovenia", "Great Britain", "Denmark",
#                                "France", "Germany", "Great Britain", "Russia", "Great Britain",
#                                "Hungary", "France", "Hungary", "Spain", "Great Britain",
#                                "Sweden", "Germany", "Czech Republic", "Russia", "Lithuania",
#                                "Italy", "Germany", "Greece", "Greece", "Portugal", "Hungary",
#                                "Great Britain", "Italy", "Russia", "Russia", "Germany",
#                                "Hungary", "Germany", "Lithuania", "Great Britain", "France",
#                                "Switzerland", "Poland", "Germany", "Lithuania", "Germany",
#                                "Great Britain", "Czech Republic", "Spain", "Czech Republic",
#                                "Poland", "Great Britain", "Russia"), Finals = c("50.18",
#                                                                                      "50.19", "50.22", "50.33", "50.39", "50.65", "50.67", "50.67",
#                                                                                      "50.71", "50.73", "50.92", "50.96", "51.01", "51.05", "51.30",
#                                                                                      "51.36", "51.48", "51.49", "51.68", "52.09", "4:12.87", "4:13.43",
#                                                                                      "4:13.86", "4:14.37", "4:15.88", "4:17.02", "4:18.33", "4:18.78",
#                                                                                      "4:20.27", "4:20.30", "1:58.71", "1:59.54", "1:59.84", "2:00.34",
#                                                                                      "2:00.75", "2:00.79", "2:01.19", "2:01.52", "2:01.56", "2:01.62",
#                                                                                      "2:01.90", "2:02.14", "2:02.32", "2:02.50", "2:03.05", "2:03.39",
#                                                                                      "2:04.73", "2:04.79", "2:05.05", "2:05.55", "2:27.33", "2:29.91",
#                                                                                      "2:31.27", "2:31.34", "2:31.74", "2:32.23", "2:32.76", "2:33.39",
#                                                                                      "2:34.33", "2:34.45", "2:34.66", "2:35.28", "2:35.78", "2:36.40",
#                                                                                      "2:36.93", "2:37.31", "2:38.11", "2:39.85", "2:40.03", "2:41.08",
#                                                                                      "1:59.91", "2:01.60", "2:03.66", "2:03.85", "2:03.91", "2:04.11",
#                                                                                      "2:04.30", "2:04.59", "2:04.83", NA, "2:05.53", "2:05.54",
#                                                                                      "2:05.69", "2:05.74", "2:06.45", "2:07.15", "2:07.25", "2:07.41",
#                                                                                      "2:08.01", "2:08.31", "3:29.10", "3:33.25", "3:34.23", "3:34.43",
#                                                                                      "3:35.58", "3:36.12", "3:38.35", "3:38.59", "3:42.46", "3:42.83",
#                                                                                      "15:13.51", "15:13.85", "15:19.63", "15:27.06", "15:28.35",
#                                                                                      "15:28.79", "15:30.12", "15:30.17", "15:31.36", "15:43.69",
#                                                                                      "15:44.95", "15:49.85", "15:52.23", "15:52.96", "15:53.36",
#                                                                                      "16:13.03", "16:13.45", "16:15.38", "16:30.58", "16:38.38",
#                                                                                      "16:38.55", "54.78", "55.76", "55.92", "56.22", "56.31",
#                                                                                      "56.34", "56.34", "56.47", "56.97", "57.27", "2:11.24", "2:12.14",
#                                                                                      "2:12.75", "2:13.72", "2:13.82", "2:14.29", "2:15.51", "2:16.60",
#                                                                                      "2:16.79", "2:17.25", "55.08", "55.44", "55.73", "55.83",
#                                                                                      "55.87", "56.14", "56.45", "56.74", "56.86", "56.89", "2:12.27",
#                                                                                      "2:12.69", "2:13.92", "2:14.11", "2:15.07", "2:17.32", "2:17.43",
#                                                                                      "2:18.58", "2:18.69", "2:20.69", "2:13.90", "2:14.28", "2:14.61",
#                                                                                      "2:14.63", "2:14.99", "2:15.22", "2:17.70", "2:17.95", "2:18.51",
#                                                                                      NA), Points = c("816", "816", "815", "809", "806", "794",
#                                                                                                      "793", "793", "791", "790", "781", "780", "777", "775", "764",
#                                                                                                      "761", "756", "756", "747", "730", "845", "840", "836", "831",
#                                                                                                      "816", "805", "793", "789", "775", "775", NA, NA, NA, NA,
#                                                                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#                                                                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#                                                                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#                                                                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "729", "687",
#                                                                                                      "678", "676", "665", "660", "640", "638", "605", "602", "866",
#                                                                                                      "865", "849", "829", "825", "824", "821", "821", "817", "786",
#                                                                                                      "783", "771", "765", "763", "762", "717", "716", "712", "679",
#                                                                                                      "664", "663", "858", "814", "807", "794", "790", "789", "789",
#                                                                                                      "783", "763", "751", NA, NA, NA, NA, NA, NA, NA, NA, NA,
#                                                                                                      NA, "838", "822", "809", "805", "803", "791", "778", "767",
#                                                                                                      "762", "761", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
#                                                                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA), DQ = c(0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#                                                                                                                                                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1)), row.names = c(NA,
#                                                                                                                                                                                                            -171L), class = "data.frame")
#
#
#   expect_equivalent(df_test, df_standard)
#
#   place_sum <- sum(as.numeric(df_test$Place), na.rm = TRUE)
#   expect_equivalent(place_sum, 1443)
#
#   dq_sum <- sum(df_test$DQ, na.rm = TRUE)
#   expect_equivalent(dq_sum, 1)
#
# })

test_that("2017 Open belgian Champs, has prelims, team-country", {
  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/Open_Belgian_Champs_2017.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse() %>%
    select(-Event)

  place_sum <- sum(as.numeric(df_test$Place), na.rm = TRUE)
  dq_sum <- sum(df_test$DQ, na.rm = TRUE)


  expect_equivalent(place_sum, 26332)
  expect_equivalent(dq_sum, 42)

})

test_that("2017 Open belgian Champs, has prelims, team-country, splits", {
  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/Open_Belgian_Champs_2017.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse(splits = TRUE) %>%
    select(-Event)

  df_test_dim <- dim(df_test)

  expect_equivalent(df_test_dim, c(1709, 108))
  # rows 1709 fully checked

  df_test_head <- df_test %>%
    head(5)

  df_standard <-
    structure(list(Place = c("1", "2", "3", "4", "5"), Name = c("SMITS, Jade",
                                                                "HANSENNE, Nona", "JONGMAN, Indy", "DOBRIN, Alexandra", "VAN WALLENDAEL, Sarah"
    ), Age = c("01", "01", "01", "93", "02"), Team = c("BEL-BRABO",
                                                       "BEL-AART", "NED-KNZB", "ROU-CNBA", "BEL-BRABO"), Prelims = c("2:18.04",
                                                                                                                          "2:20.62", "2:18.24", "2:21.70", "2:23.61"), Finals = c("2:18.55",
                                                                                                                                                                                       "2:20.52", "2:21.93", "2:22.30", "2:22.96"), Points = c("717",
                                                                                                                                                                                                                                               "688", "667", "662", "653"), DQ = c("0", "0", "0", "0", "0"),
    Split_50 = c("31.01", "33.03", "32.89", "32.36", "33.69"),
    Split_100 = c("1:05.93", "1:08.70", "1:09.00", "1:08.43",
                  "1:10.52"), Split_150 = c("1:42.36", "1:44.93", "1:46.12",
                                            "1:45.40", "1:47.14"), Split_200 = c("2:18.55", "2:20.52",
                                                                                 "2:21.93", "2:22.30", "2:22.96"), Split_250 = c(NA_character_,
                                                                                                                                 NA_character_, NA_character_, NA_character_, NA_character_
                                                                                 ), Split_300 = c(NA_character_, NA_character_, NA_character_,
                                                                                                  NA_character_, NA_character_), Split_350 = c(NA_character_,
                                                                                                                                               NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                  ), Split_400 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                   NA_character_, NA_character_), Split_450 = c(NA_character_,
                                                                                                                                                                NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                   ), Split_500 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                    NA_character_, NA_character_), Split_550 = c(NA_character_,
                                                                                                                                                                                 NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                    ), Split_600 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                     NA_character_, NA_character_), Split_650 = c(NA_character_,
                                                                                                                                                                                                  NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                     ), Split_700 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                      NA_character_, NA_character_), Split_750 = c(NA_character_,
                                                                                                                                                                                                                   NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                      ), Split_800 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                       NA_character_, NA_character_), Split_850 = c(NA_character_,
                                                                                                                                                                                                                                    NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                       ), Split_900 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                        NA_character_, NA_character_), Split_950 = c(NA_character_,
                                                                                                                                                                                                                                                     NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                        ), Split_1000 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                          NA_character_, NA_character_), Split_1050 = c(NA_character_,
                                                                                                                                                                                                                                                                        NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                          ), Split_1100 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                            NA_character_, NA_character_), Split_1150 = c(NA_character_,
                                                                                                                                                                                                                                                                                          NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                            ), Split_1200 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                              NA_character_, NA_character_), Split_1250 = c(NA_character_,
                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                              ), Split_1300 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                NA_character_, NA_character_), Split_1350 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                ), Split_1400 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_), Split_1450 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                  ), Split_1500 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_), Split_1550 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                    ), Split_1600 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_), Split_1650 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                      ), Split_1700 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_), Split_1750 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                        ), Split_1800 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_), Split_1850 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                          ), Split_1900 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_), Split_1950 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                            ), Split_2000 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_), Split_2050 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                              ), Split_2100 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_), Split_2150 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                ), Split_2200 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_), Split_2250 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                  ), Split_2300 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_), Split_2350 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ), Split_2400 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_), Split_2450 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ), Split_2500 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_), Split_2550 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ), Split_2600 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_), Split_2650 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ), Split_2700 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_), Split_2750 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ), Split_2800 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_), Split_2850 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ), Split_2900 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_), Split_2950 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ), Split_3000 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_), Split_3050 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ), Split_3100 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_), Split_3150 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ), Split_3200 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_), Split_3250 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ), Split_3300 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_), Split_3350 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ), Split_3400 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_), Split_3450 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ), Split_3500 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_), Split_3550 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ), Split_3600 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_), Split_3650 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ), Split_3700 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_), Split_3750 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ), Split_3800 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_), Split_3850 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ), Split_3900 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_), Split_3950 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ), Split_4000 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_), Split_4050 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ), Split_4100 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_), Split_4150 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ), Split_4200 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_), Split_4250 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ), Split_4300 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_), Split_4350 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ), Split_4400 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_), Split_4450 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ), Split_4500 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_), Split_4550 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ), Split_4600 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_), Split_4650 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ), Split_4700 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_), Split_4750 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ), Split_4800 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_), Split_4850 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ), Split_4900 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        NA_character_, NA_character_), Split_4950 = c(NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      NA_character_, NA_character_, NA_character_, NA_character_
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ), Split_5000 = c(NA_character_, NA_character_, NA_character_,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          NA_character_, NA_character_)), row.names = c(NA, 5L), class = "data.frame")

  expect_equivalent(df_test_head, df_standard)
})

test_that("Glenmark Senior Nationals 2019 relays", {

  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/Glenmark_Senior_Nationals_2019.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse(splits = TRUE, split_length = 100)

  df_test_relay <- df_test %>%
    filter(str_detect(Event, " x ")) %>%
    select(where(~ !all(is.na(.x)))) %>%
    select(-Event)

  df_standard <-
    structure(list(Place = c("1", "2", "3", "4", "5", "6", "7", "1",
                             "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6",
                             "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3",
                             "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8",
                             "1", "2", "3", "4", "5", "1", "2", "3", "4", "5", "6", "7", "8"
    ), Team = c("KARNATAKA", "SSCB", "R.S.P.B", "POLICE", "BENGAL",
                "MAHARASHTRA", "KERALA", "KARNATAKA", "MAHARASHTRA", "R.S.P.B",
                "GUJARAT", "TAMILNADU", "DELHI", "BENGAL", "KERALA", "MAHARASHTRA",
                "KARNATAKA", "TAMILNADU", "DELHI", "BENGAL", "KERALA", "GUJARAT",
                "PUNJAB", "KARNATAKA", "SSCB", "MAHARASHTRA", "R.S.P.B", "DELHI",
                "BENGAL", "KERALA", "TELANGANA", "KARNATAKA", "SSCB", "R.S.P.B",
                "DELHI", "KERALA", "MAHARASHTRA", "BENGAL", "POLICE", "MAHARASHTRA",
                "KARNATAKA", "TAMILNADU", "GUJARAT", "BENGAL", "DELHI", "KERALA",
                "PUNJAB", "KARNATAKA", "MAHARASHTRA", "TAMILNADU", "BENGAL",
                "KERALA", "MAHARASHTRA", "R.S.P.B", "KARNATAKA", "DELHI", "KERALA",
                "TAMILNADU", "BENGAL", "GUJARAT"), Finals = c("7:46.04",
                                                                   "7:49.31", "7:53.52", "8:19.53", "8:20.32", "8:24.45", "8:46.12",
                                                                   "1:50.65", "1:52.82", "1:54.00", "1:55.67", "1:57.23", "2:00.50",
                                                                   "2:01.71", "2:01.90", "4:02.90", "4:09.88", "4:13.25", "4:14.84",
                                                                   "4:15.54", "4:29.80", "4:31.50", "4:47.63", "3:30.45", "3:31.04",
                                                                   "3:31.17", "3:33.22", "3:37.07", "3:43.67", "3:45.01", "4:02.50",
                                                                   "3:48.83", "3:52.11", "3:52.93", "4:01.27", "4:02.53", "4:04.46",
                                                                   "4:07.31", "4:39.37", "4:33.10", "4:34.84", "4:39.49", "4:40.06",
                                                                   "4:41.20", "4:52.31", "4:56.41", "5:32.06", "9:04.86", "9:08.51",
                                                                   "9:09.18", "9:23.37", "9:56.91", "1:39.69", "1:41.83", "1:41.92",
                                                                   "1:44.95", "1:47.70", "1:48.06", "1:49.74", "1:50.08"), Points = c("724",
                                                                                                                                      "709", "690", "588", "585", "571", "503", NA, NA, NA, NA, NA,
                                                                                                                                      NA, NA, NA, "646", "593", "570", "559", "555", "471", "463",
                                                                                                                                      "389", "715", "709", "708", "688", "652", "596", "585", "467",
                                                                                                                                      "743", "712", "704", "634", "624", "609", "588", "408", "609",
                                                                                                                                      "597", "568", "565", "558", "497", "476", "339", "609", "597",
                                                                                                                                      "595", "551", "463", NA, NA, NA, NA, NA, NA, NA, NA), DQ = c("0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0"), Split_100 = c("1:55.46",
                                                                                                                                                                                                                                                     "1:54.39", "1:58.53", NA, "2:03.92", "2:09.81", "2:04.90", NA,
                                                                                                                                                                                                                                                     NA, NA, NA, NA, NA, NA, NA, NA, "1:02.46", "1:03.01", NA, "1:04.60",
                                                                                                                                                                                                                                                     "1:08.63", NA, "1:09.59", "53.37", "53.99", NA, "52.56", "54.01",
                                                                                                                                                                                                                                                     "56.86", "56.59", NA, NA, "59.10", "1:00.03", "59.44", NA, "1:02.30",
                                                                                                                                                                                                                                                     "1:04.93", NA, "1:10.05", "1:08.93", "1:08.06", "1:10.09", "1:07.24",
                                                                                                                                                                                                                                                     NA, NA, "1:23.43", "2:17.38", "2:18.21", "2:21.40", "2:20.05",
                                                                                                                                                                                                                                                     "2:21.76", NA, NA, NA, NA, NA, NA, NA, NA), Split_200 = c("1:58.43",
                                                                                                                                                                                                                                                                                                               "1:57.62", NA, NA, "2:06.58", "2:06.64", NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                               NA, NA, NA, NA, NA, "1:02.21", "1:04.40", NA, "1:06.10", "1:08.30",
                                                                                                                                                                                                                                                                                                               NA, "1:11.60", "53.24", "54.04", NA, "53.94", "54.93", "56.22",
                                                                                                                                                                                                                                                                                                               "58.22", NA, NA, "56.92", NA, "59.58", NA, "59.99", NA, NA, "1:05.60",
                                                                                                                                                                                                                                                                                                               "1:06.97", "1:16.16", "1:02.48", NA, NA, NA, "1:24.38", "2:15.53",
                                                                                                                                                                                                                                                                                                               "2:21.32", "2:21.77", "2:23.01", "2:31.97", NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                               NA, NA, NA), Split_300 = c("1:29.54", "1:31.42", NA, "2:05.96",
                                                                                                                                                                                                                                                                                                                                          "2:06.84", "2:03.42", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                          "1:03.42", "1:04.36", NA, "1:04.24", "1:07.29", NA, "1:16.70",
                                                                                                                                                                                                                                                                                                                                          "53.20", "52.04", NA, "52.97", "55.14", "55.05", "55.50", NA,
                                                                                                                                                                                                                                                                                                                                          NA, "1:04.97", "1:06.00", "1:08.29", NA, "1:07.49", "55.48",
                                                                                                                                                                                                                                                                                                                                          NA, "1:14.61", "1:16.47", "1:19.67", NA, "1:01.15", NA, NA, "1:28.46",
                                                                                                                                                                                                                                                                                                                                          "2:21.02", "2:15.75", "2:14.79", "2:18.45", "2:31.21", NA, NA,
                                                                                                                                                                                                                                                                                                                                          NA, NA, NA, NA, NA, NA), Split_400 = c("2:22.61", "2:25.88",
                                                                                                                                                                                                                                                                                                                                                                                 NA, "2:07.68", "2:02.98", "2:04.58", "2:15.50", NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                 NA, NA, NA, NA, NA, "1:01.79", "1:01.48", NA, "1:00.60", "1:05.58",
                                                                                                                                                                                                                                                                                                                                                                                 NA, "1:09.74", "50.64", "50.97", NA, "53.75", "52.99", "55.54",
                                                                                                                                                                                                                                                                                                                                                                                 "54.70", NA, NA, "51.12", NA, "53.96", NA, "54.68", NA, NA, "1:02.84",
                                                                                                                                                                                                                                                                                                                                                                                 "1:02.47", "55.60", NA, NA, NA, NA, "1:15.79", "2:10.93", "2:13.23",
                                                                                                                                                                                                                                                                                                                                                                                 "2:11.22", "2:21.86", "2:31.97", NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                 NA)), row.names = c(NA, -60L), class = "data.frame")

  expect_equivalent(df_test_relay, df_standard)

  df_test_ind <- df_test %>%
    head(5) %>%
    select(where(~ !all(is.na(.x))))

  df_standard <-
    structure(list(Place = c("1", "2", "3", "4", "5"), Name = c("Kushagra Rawat",
                                                                "ANAND AS", "AARON FERNANDES", "Vishal Grewal", "Anurag R. Singh"
    ), Age = c("90", NA, NA, "90", NA), Team = c("DELHI", "SSCB",
                                                 "MAHARASHTRA", "DELHI", "UTTAR PRADESH"), Finals = c("3:56.95",
                                                                                                           "4:01.92", "4:04.71", "4:07.44", "4:09.34"), Points = c("801",
                                                                                                                                                                   "752", "727", "703", "687"), DQ = c("0", "0", "0", "0", "0"),
    Event = c("Men, 400m Freestyle", "Men, 400m Freestyle", "Men, 400m Freestyle",
              "Men, 400m Freestyle", "Men, 400m Freestyle"), Split_100 = c("58.11",
                                                                           "1:02.00", "1:00.47", "58.70", "1:00.54"), Split_200 = c("1:00.23",
                                                                                                                                    "1:00.56", NA, "1:02.64", "1:03.75"), Split_300 = c("59.57",
                                                                                                                                                                                        "3:01.36", "3:04.24", "1:03.76", "1:04.16"), Split_400 = c("59.04",
                                                                                                                                                                                                                                                   "4:01.92", "4:04.71", "1:02.34", "1:00.89")), row.names = c(NA,
                                                                                                                                                                                                                                                                                                               5L), class = "data.frame")

  expect_equivalent(df_test_ind, df_standard)
})


test_that("Glenmark Senior Nationals 2019 with splits and relays", {

  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/Glenmark_Senior_Nationals_2019.pdf"

  df <- file %>%
    read_results() %>%
    swim_parse(splits = TRUE, split_length = 100, relay_swimmers = TRUE)

  df_test_relay <- df %>%
    filter(str_detect(Event, " x ")) %>%
    select(where( ~ !all(is.na(.x)))) %>%
    select(-Event)

  df_standard_relay <-
    structure(list(Place = c("1", "2", "3", "4", "5", "6", "7", "1",
                             "2", "3", "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6",
                             "7", "8", "1", "2", "3", "4", "5", "6", "7", "8", "1", "2", "3",
                             "4", "5", "6", "7", "8", "1", "2", "3", "4", "5", "6", "7", "8",
                             "1", "2", "3", "4", "5", "1", "2", "3", "4", "5", "6", "7", "8"
    ), Team = c("KARNATAKA", "SSCB", "R.S.P.B", "POLICE", "BENGAL",
                "MAHARASHTRA", "KERALA", "KARNATAKA", "MAHARASHTRA", "R.S.P.B",
                "GUJARAT", "TAMILNADU", "DELHI", "BENGAL", "KERALA", "MAHARASHTRA",
                "KARNATAKA", "TAMILNADU", "DELHI", "BENGAL", "KERALA", "GUJARAT",
                "PUNJAB", "KARNATAKA", "SSCB", "MAHARASHTRA", "R.S.P.B", "DELHI",
                "BENGAL", "KERALA", "TELANGANA", "KARNATAKA", "SSCB", "R.S.P.B",
                "DELHI", "KERALA", "MAHARASHTRA", "BENGAL", "POLICE", "MAHARASHTRA",
                "KARNATAKA", "TAMILNADU", "GUJARAT", "BENGAL", "DELHI", "KERALA",
                "PUNJAB", "KARNATAKA", "MAHARASHTRA", "TAMILNADU", "BENGAL",
                "KERALA", "MAHARASHTRA", "R.S.P.B", "KARNATAKA", "DELHI", "KERALA",
                "TAMILNADU", "BENGAL", "GUJARAT"), Finals = c("7:46.04",
                                                                   "7:49.31", "7:53.52", "8:19.53", "8:20.32", "8:24.45", "8:46.12",
                                                                   "1:50.65", "1:52.82", "1:54.00", "1:55.67", "1:57.23", "2:00.50",
                                                                   "2:01.71", "2:01.90", "4:02.90", "4:09.88", "4:13.25", "4:14.84",
                                                                   "4:15.54", "4:29.80", "4:31.50", "4:47.63", "3:30.45", "3:31.04",
                                                                   "3:31.17", "3:33.22", "3:37.07", "3:43.67", "3:45.01", "4:02.50",
                                                                   "3:48.83", "3:52.11", "3:52.93", "4:01.27", "4:02.53", "4:04.46",
                                                                   "4:07.31", "4:39.37", "4:33.10", "4:34.84", "4:39.49", "4:40.06",
                                                                   "4:41.20", "4:52.31", "4:56.41", "5:32.06", "9:04.86", "9:08.51",
                                                                   "9:09.18", "9:23.37", "9:56.91", "1:39.69", "1:41.83", "1:41.92",
                                                                   "1:44.95", "1:47.70", "1:48.06", "1:49.74", "1:50.08"), Points = c("724",
                                                                                                                                      "709", "690", "588", "585", "571", "503", NA, NA, NA, NA, NA,
                                                                                                                                      NA, NA, NA, "646", "593", "570", "559", "555", "471", "463",
                                                                                                                                      "389", "715", "709", "708", "688", "652", "596", "585", "467",
                                                                                                                                      "743", "712", "704", "634", "624", "609", "588", "408", "609",
                                                                                                                                      "597", "568", "565", "558", "497", "476", "339", "609", "597",
                                                                                                                                      "595", "551", "463", NA, NA, NA, NA, NA, NA, NA, NA), DQ = c("0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                                                                                                                                                                                                   "0", "0", "0", "0", "0", "0", "0"), Relay_Swimmer_1 = c("Siva S",
                                                                                                                                                                                                                                                           "ANAND AS", "Sanu Debnath", "Mandar Anandrao Divase", "Rajdip Roy",
                                                                                                                                                                                                                                                           "GOURAV CHAVAN", "Arjun Anesh K", "Shrihari Nataraj", "JYOTSNA PANSARE",
                                                                                                                                                                                                                                                           "Soumyajit Saha", "Maana Patel", "Sethu Manickavel T", "Siddhant Sejwal",
                                                                                                                                                                                                                                                           "Soubrity Mondal", "Aaron J Thomas", "RUJUTA KHADE", "Smruthi Mahalingam",
                                                                                                                                                                                                                                                           "Swarna K Harith", "Pallavi Sejwal", "Shristi Upadhyay", "Jomi George",
                                                                                                                                                                                                                                                           "Niva Sharma", "Gurnoor Kaur", "Tanish George Mathew", "NIMISH MULEY",
                                                                                                                                                                                                                                                           "VIRDHAWAL KHADE", "Viraj Prabhu", "Kushagra Rawat", "Rajdip Roy",
                                                                                                                                                                                                                                                           "Abhijith Gegarin", "Yash Varma", "Shrihari Nataraj", "ARVIND MANI",
                                                                                                                                                                                                                                                           "Soumyajit Saha", "Siddhant Sejwal", "Aaron J Thomas", "MEHLAM GHADIALY",
                                                                                                                                                                                                                                                           "Pratyay Bhattacharya", "Mandar Anandrao Divase", "YUGA BIRNALE",
                                                                                                                                                                                                                                                           "Ridhima Veerendra Kumar", "Meenakshi V K R", "Maana Patel",
                                                                                                                                                                                                                                                           "Soubrity Mondal", "Riniki Bordoloi", "Sanaa Mathew", "Deepali Attri",
                                                                                                                                                                                                                                                           "Damini K Gowda", "YUGA BIRNALE", "Swarna K Harith", "Shristi Upadhyay",
                                                                                                                                                                                                                                                           "Bhadrasudevan. S", "MIHIR AMBRE", "Aaron D' Souza", "Likith S P",
                                                                                                                                                                                                                                                           "Siddhant Sejwal", "Abhijith Gegarin", "Sethu Manickavel T",
                                                                                                                                                                                                                                                           "Shrinjan Pal", "Harshal Sarang"), Relay_Swimmer_2 = c("Avinash Mani",
                                                                                                                                                                                                                                                                                                                  "KUNTAL GIRI", "Soumyajit Saha", "Munish Kumar", "Army Pal",
                                                                                                                                                                                                                                                                                                                  "RISHABH CHAUBEY", "Akash. S", "Suvana C Baskar", "VIRDHAWAL KHADE",
                                                                                                                                                                                                                                                                                                                  "Avantika Chavan", "Anshul Kothari", "Meenakshi V K R", "Pallavi Sejwal",
                                                                                                                                                                                                                                                                                                                  "Kunal Basak", "Liyana Fathima Umer", "SADHVI DHURI", "Suvana C Baskar",
                                                                                                                                                                                                                                                                                                                  "Shakthi B", "Riniki Bordoloi", "Oendrila Banerjee", "Sanaa Mathew",
                                                                                                                                                                                                                                                                                                                  "SILKI NAGPURE", "Bhavjot Kaur", "Siva S", "GAURAV YADAV KA",
                                                                                                                                                                                                                                                                                                                  "MIHIR AMBRE", "Anoop Augustine", "Samit Sejwal", "Swapnil Chakraborty",
                                                                                                                                                                                                                                                                                                                  "Arjun Anesh K", "M. Tejasvin", "Rakshith U shetty", "SHIVAKSH SAHU",
                                                                                                                                                                                                                                                                                                                  "Supriya Mondal", "Sameer Sejwal", "Arjun. M", "MIHIR AMBRE",
                                                                                                                                                                                                                                                                                                                  "Swapnil Chakraborty", "Sandeep Panghal", "APEKSHA FERNANDES",
                                                                                                                                                                                                                                                                                                                  "Damini K Gowda", "Shakthi B", "Arushi S K M", "Nilabjaa Ghosh",
                                                                                                                                                                                                                                                                                                                  "Hema", "Shreya Mary Kamal", "Gurnoor Kaur", "Suvana C Baskar",
                                                                                                                                                                                                                                                                                                                  "SIYAA SHETTY", "Meenakshi V K R", "Oendrila Banerjee", "Jomi George",
                                                                                                                                                                                                                                                                                                                  "KENISHA GUPTA", "Avantika Chavan", "Deeksha Ramesh", "Priyank Rana",
                                                                                                                                                                                                                                                                                                                  "Greeshma.P", "Jayaveena A V", "Priyanka Manna", "Niva Sharma"
                                                                                                                                                                                                                                                           ), Relay_Swimmer_3 = c("Tanish George Mathew", "JAYANT M", "Anoop Augustine",
                                                                                                                                                                                                                                                                                  "Aman Ghai", "Pratyay Bhattacharya", "AARYAN BHOSALE", "Arun. M",
                                                                                                                                                                                                                                                                                  "Likith S P", "SHWEJAL MANKAR", "Viraj Prabhu", "Oum Saxena",
                                                                                                                                                                                                                                                                                  "Danush S", "Aditya Dubey", "Srishti Basu", "Suneesh. S", "APEKSHA FERNANDES",
                                                                                                                                                                                                                                                                                  "Inchara B", "Jayaveena A V", "Saanvi Sood", "Priyanka Manna",
                                                                                                                                                                                                                                                                                  "Liyana Fathima Umer", "Arushi S K M", "Nishtha Sharma", "Prithvi M",
                                                                                                                                                                                                                                                                                  "VINAY SAHARAN", "SHWEJAL MANKAR", "Sanu Debnath", "Tanmay Das",
                                                                                                                                                                                                                                                                                  "Kunal Basak", "Amridhesh. U", "Tanneru Sai Tarun", "Likith S P",
                                                                                                                                                                                                                                                                                  "ASHISH TOKAS", "M Lohith.", "Aditya Dubey", "Suneesh. S", "JAY EKBOTE",
                                                                                                                                                                                                                                                                                  "Swadesh Mondal", "Munish Kumar", "KAREENA SHANKTA", "Saloni Dalal",
                                                                                                                                                                                                                                                                                  "Shriya Ishwar Prasad", "Kalyani Saxena", "Srishti Basu", "Saanvi Sood",
                                                                                                                                                                                                                                                                                  "Aradhana Bekal", "Chahat Arora", "Smruthi Mahalingam", "SADHVI DHURI",
                                                                                                                                                                                                                                                                                  "Shakthi B", "Priyanka Manna", "Arya G Nair", "RUJUTA KHADE",
                                                                                                                                                                                                                                                                                  "Aditi Dhumatkar", "Smruthi Mahalingam", "Pallavi Sejwal", "Arjun Sambu. A",
                                                                                                                                                                                                                                                                                  "Swarna K Harith", "Shristi Upadhyay", "Maana Patel"), Relay_Swimmer_4 = c("Shrihari Nataraj",
                                                                                                                                                                                                                                                                                                                                                             "VINAY SAHARAN", "Saurabh Sangvekar", "Sajan Prakash", "Kunal Basak",
                                                                                                                                                                                                                                                                                                                                                             "AARON FERNANDES", "Amal. A", "Deeksha Ramesh", "KENISHA GUPTA",
                                                                                                                                                                                                                                                                                                                                                             "Aditi Dhumatkar", "Niva Sharma", "Jayaveena A V", "Bhavya Sachdeva",
                                                                                                                                                                                                                                                                                                                                                             "Shrinjan Pal", "Greeshma.P", "KENISHA GUPTA", "Khushi Dinesh",
                                                                                                                                                                                                                                                                                                                                                             "Bhavika Dugar", "Bhavya Sachdeva", "Janhvi Choudhury", "Bhadrasudevan. S",
                                                                                                                                                                                                                                                                                                                                                             "Maana Patel", "Deepali Attri", "Shrihari Nataraj", "ANAND AS",
                                                                                                                                                                                                                                                                                                                                                             "AARON FERNANDES", "Saurabh Sangvekar", "Vishal Grewal", "Shrinjan Pal",
                                                                                                                                                                                                                                                                                                                                                             "Amal. A", "Challagani Abhilash", "Prithvi M", "ANAND AS", "Viraj Prabhu",
                                                                                                                                                                                                                                                                                                                                                             "Vishal Grewal", "Abhijith Gegarin", "AARON FERNANDES", "Shrinjan Pal",
                                                                                                                                                                                                                                                                                                                                                             "Aman Ghai", "KENISHA GUPTA", "Khushi Dinesh", "Swarna K Harith",
                                                                                                                                                                                                                                                                                                                                                             "Niva Sharma", "Janhvi Choudhury", "Bhavya Sachdeva", "Jomi George",
                                                                                                                                                                                                                                                                                                                                                             "Bhavjot Kaur", "Khushi Dinesh", "RUTUJA TALEGAONKAR", "Bhavika Dugar",
                                                                                                                                                                                                                                                                                                                                                             "Soubrity Mondal", "Iris Manoj", "VIRDHAWAL KHADE", "Viraj Prabhu",
                                                                                                                                                                                                                                                                                                                                                             "Shrihari Nataraj", "Bhavya Sachdeva", "Jomi George", "Danush S",
                                                                                                                                                                                                                                                                                                                                                             "Kunal Basak", "Anshul Kothari"), Split_100 = c("1:55.46", "1:54.39",
                                                                                                                                                                                                                                                                                                                                                                                                             "1:58.53", NA, "2:03.92", "2:09.81", "2:04.90", NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, "1:02.46", "1:03.01", NA, "1:04.60", "1:08.63",
                                                                                                                                                                                                                                                                                                                                                                                                             NA, "1:09.59", "53.37", "53.99", NA, "52.56", "54.01", "56.86",
                                                                                                                                                                                                                                                                                                                                                                                                             "56.59", NA, NA, "59.10", "1:00.03", "59.44", NA, "1:02.30",
                                                                                                                                                                                                                                                                                                                                                                                                             "1:04.93", NA, "1:10.05", "1:08.93", "1:08.06", "1:10.09", "1:07.24",
                                                                                                                                                                                                                                                                                                                                                                                                             NA, NA, "1:23.43", "2:17.38", "2:18.21", "2:21.40", "2:20.05",
                                                                                                                                                                                                                                                                                                                                                                                                             "2:21.76", NA, NA, NA, NA, NA, NA, NA, NA), Split_200 = c("1:58.43",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "1:57.62", NA, NA, "2:06.58", "2:06.64", NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, "1:02.21", "1:04.40", NA, "1:06.10", "1:08.30",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, "1:11.60", "53.24", "54.04", NA, "53.94", "54.93", "56.22",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "58.22", NA, NA, "56.92", NA, "59.58", NA, "59.99", NA, NA, "1:05.60",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "1:06.97", "1:16.16", "1:02.48", NA, NA, NA, "1:24.38", "2:15.53",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "2:21.32", "2:21.77", "2:23.01", "2:31.97", NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA), Split_300 = c("1:29.54", "1:31.42", NA, "2:05.96",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  "2:06.84", "2:03.42", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  "1:03.42", "1:04.36", NA, "1:04.24", "1:07.29", NA, "1:16.70",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  "53.20", "52.04", NA, "52.97", "55.14", "55.05", "55.50", NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA, "1:04.97", "1:06.00", "1:08.29", NA, "1:07.49", "55.48",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA, "1:14.61", "1:16.47", "1:19.67", NA, "1:01.15", NA, NA, "1:28.46",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  "2:21.02", "2:15.75", "2:14.79", "2:18.45", "2:31.21", NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA, NA, NA, NA, NA, NA), Split_400 = c("2:22.61", "2:25.88",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         NA, "2:07.68", "2:02.98", "2:04.58", "2:15.50", NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         NA, NA, NA, NA, NA, "1:01.79", "1:01.48", NA, "1:00.60", "1:05.58",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         NA, "1:09.74", "50.64", "50.97", NA, "53.75", "52.99", "55.54",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         "54.70", NA, NA, "51.12", NA, "53.96", NA, "54.68", NA, NA, "1:02.84",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         "1:02.47", "55.60", NA, NA, NA, NA, "1:15.79", "2:10.93", "2:13.23",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         "2:11.22", "2:21.86", "2:31.97", NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         NA)), row.names = c(NA, -60L), class = "data.frame")

  expect_equivalent(df_test_relay, df_standard_relay)
})

test_that("RBSF 100 free with merged teams/ages", {
  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/RBSF_100Free.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse(splits = TRUE)

  df_standard <-
    structure(list(Place = c("1", "2", "3", "4", "5", "6", "7", "8"
    ), Name = c("VERDONCK, Fleur", "DUREZ, Laure", "WOUTERS, Briana",
                "HENVEAUX, Camille", "VAN DEN EEDE, Lisa", "DUJARDIN, Faye",
                "SEYNAEVE, Marthe", "VANDEPOORTE, Pauline"), Age = c("06", "06",
                                                                     "06", "06", "06", "06", "06", "06"), Team = c("ZGEEL", "ENLN",
                                                                                                                   "HZA", "LGN", "AZL", "GOLD", "BZK", "FAST"), Prelims = c("55.92",
                                                                                                                                                                                 "57.25", "57.81", "58.54", "1:00.96", "1:00.17", "1:00.59", "1:00.77"
                                                                                                                   ), Finals = c("57.50", "57.77", "58.91", "59.53", "1:01.72",
                                                                                                                                      "1:02.25", "1:02.55", "1:03.21"), DQ = c("0", "0", "0", "0",
                                                                                                                                                                               "0", "0", "0", "0"), Event = c("Girls, 100m Freestyle 15 years",
                                                                                                                                                                                                              "Girls, 100m Freestyle 15 years", "Girls, 100m Freestyle 15 years",
                                                                                                                                                                                                              "Girls, 100m Freestyle 15 years", "Girls, 100m Freestyle 15 years",
                                                                                                                                                                                                              "Girls, 100m Freestyle 15 years", "Girls, 100m Freestyle 15 years",
                                                                                                                                                                                                              "Girls, 100m Freestyle 15 years"), Split_50 = c("27.73", "28.09",
                                                                                                                                                                                                                                                              "28.13", "28.95", "29.78", "29.53", "29.73", "30.07"), Split_100 = c("57.50",
                                                                                                                                                                                                                                                                                                                                   "57.77", "58.91", "59.53", "1:01.72", "1:02.25", "1:02.55", "1:03.21"
                                                                                                                                                                                                                                                              )), row.names = c(NA, -8L), class = "data.frame")


  expect_equivalent(df_test, df_standard)

})

test_that("RBSF 50 free with merged teams/ages, also has a tie", {
  skip_on_cran()

  file <-
    "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/RBSF_50Free.pdf"

  df_test <- file %>%
    read_results() %>%
    swim_parse(splits = TRUE)

  df_standard <-
    structure(list(Place = c("1", "2", "3", "4", "5", "5", "7", "8"
    ), Name = c("SNEYERS, Kobe", "PETRE, Olivier", "WILLEMS, Dieter",
                "BOETS, Victor", "VERCAUTEREN, Jasper", "DUFLOUCQ, Seppe", "OPDEBEECK, Thomas",
                "EVENS, Thibo"), Age = c("06", "06", "06", "06", "06", "06",
                                         "06", "06"), Team = c("SHARK", "ENLN", "AZV", "MOZKA", "BRABO",
                                                               "ISWIM", "BRABO", "KAZS"), Prelims = c("25.00", "26.15",
                                                                                                           "25.79", "26.14", "26.29", "26.25", "26.15", "26.30"), Finals = c("25.69",
                                                                                                                                                                                  "26.05", "26.34", "26.57", "26.96", "26.96", "27.11", "27.66"
                                                                                                           ), DQ = c("0", "0", "0", "0", "0", "0", "0", "0"), Event = c("Boys, 50m Freestyle 15 years",
                                                                                                                                                                        "Boys, 50m Freestyle 15 years", "Boys, 50m Freestyle 15 years",
                                                                                                                                                                        "Boys, 50m Freestyle 15 years", "Boys, 50m Freestyle 15 years",
                                                                                                                                                                        "Boys, 50m Freestyle 15 years", "Boys, 50m Freestyle 15 years",
                                                                                                                                                                        "Boys, 50m Freestyle 15 years")), row.names = c(NA, -8L), class = "data.frame")

  expect_equivalent(df_test, df_standard)

})

# test_that("Euro 2018 Champs - a giant mess", {
#   skip_on_cran()
#
#
#   # as of 3/18/23 pdf_test is not reading in rows where team names run into times correctly
#   # I don't know how to fix this beyond using typo/replacement
#
#   file <-
#     "https://raw.githubusercontent.com/gpilgrim2670/Pilgrim_Data/master/Splash/EURO_MEET_2018.pdf"
#
#   df_test <- file %>%
#     read_results() %>%
#     swim_parse(splits = TRUE, relay_swimmers = TRUE)
#
#   df_standard <-
#     readRDS(url("https://github.com/gpilgrim2670/Pilgrim_Data/raw/master/Splash/Euro_2018_Splash.rds"))
#
#
#   expect_equivalent(df_test, df_standard)
#
# })

# testthat::test_file("tests/testthat/test-splash.R")

