% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sysrecon.R
\name{Sysrecon}
\alias{Sysrecon}
\title{Sysrecon}
\usage{
Sysrecon(
  inputTxt,
  stepsMatrix,
  stepTypes,
  conversionMatrix,
  conversionTypes,
  toolsMatrix,
  toolsTypes,
  contentTypes
)
}
\arguments{
\item{inputTxt}{A txt contains the methods and contents of the metabolic reconstruction in articles.}

\item{stepsMatrix}{A data frame the marker words, threshold value, steps, group and other information about the metabolic reconstruction. The default file is in the data.}

\item{stepTypes}{A data frame the labels and groups of the metabolic reconstructions steps. The default file is in the data.}

\item{conversionMatrix}{A data frame contains the marker words, threshold value, steps, group and other transformation information about the metabolic reconstruction. The default file is in the data.}

\item{conversionTypes}{A data frame contains the labels and groups of the metabolic reconstructions transformation. The default file is in the data.}

\item{toolsMatrix}{A data frame contains the marker words, threshold value, steps, group and other information about the metabolic reconstruction databases and tools. The default file is in the data.}

\item{toolsTypes}{A data frame contains the databases and the tools used in the metabolic reconstruction.}

\item{contentTypes}{A data frame contains the labels and groups of the metabolic reconstructions content The default file is in the data.}
}
\value{
The pictures that visualize the steps, transformation and databases and tools of the metabolic reconstruction.
}
\description{
Input the txt and output the visualization of the steps, transformation and databases and tools.
}
\details{
Input takes a data.frame x with two variables v and w and returns the maximum knapsack value and which elements (rows in the data.frame).
}
\examples{

exam <- Sysrecon(inputTxt, stepsMatrix, stepTypes, conversionMatrix, conversionTypes,
  toolsMatrix, toolsTypes, contentTypes)
}
