% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.r.package.R
\name{is.r.package}
\alias{is.r.package}
\title{Is R Package}
\usage{
is.r.package(targz, spec = NULL, warn = TRUE)
}
\arguments{
\item{targz}{a filename ending with \verb{tar.gz}.}

\item{spec}{an optional list generated with \code{parse.repo}.}

\item{warn}{whether to warn if the file contents look like an R package
nested inside a repository.}
}
\value{
Logical indicating whether \code{targz} is an R package.
}
\description{
Check if \file{.tar.gz} file is an R package.
}
\details{
The only purpose of passing \code{spec} is to get a more helpful warning
message if the file contents look like an R package nested inside a
repository.
}
\examples{
\dontrun{
is.r.package("boot/software/SAM.tar.gz")
is.r.package("boot/software/stockassessment.tar.gz")
}

}
