% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARorder.norm.R
\name{ARorder.norm}
\alias{ARorder.norm}
\title{Identify the autoregressive orders for a Gaussian TAR model given the number of regimes and thresholds.}
\usage{
ARorder.norm(Z, X, l, r, k_Max = 3, k_Min = 0, n.sim = 500,
  p.burnin = 0.3, n.thin = 1)
}
\arguments{
\item{Z}{The threshold series}

\item{X}{The series of interest}

\item{l}{The number of regimes.}

\item{r}{The vector of thresholds for the series \{Z_t\}.}

\item{k_Max}{The minimum value for each autoregressive order. The default is 3.}

\item{k_Min}{The maximum value for each autoregressive order. The default is 0.}

\item{n.sim}{Number of iteration for the Gibbs Sampler}

\item{p.burnin}{Percentage of iterations used for}

\item{n.thin}{Thinnin factor for the Gibbs Sampler}
}
\value{
The identified autoregressive orders with posterior probabilities
}
\description{
This function identify the autoregressive orders for a TAR model with Gaussian noise process given the number of regimes and thresholds.
}
\details{
The TAR model is given by \deqn{X_t=a_0^{(j)} + \sum_{i=1}^{k_j}a_i^{(j)}X_{t-i}+h^{(j)}e_t} when \eqn{Z_t\in (r_{j-1},r_j]} for som \eqn{j} (\eqn{j=1,\cdots,l}). 
the \eqn{\{Z_t\}} is the threshold process, \eqn{l} is the number of regimes, \eqn{k_j} is the autoregressive order in the regime \eqn{j}. \eqn{a_i^{(j)}} with \eqn{i=0,1,\cdots,k_j} denote the autoregressive coefficients, while \eqn{h^{(j)}} denote the variance weights. \eqn{\{e_t\}} is the Gaussian white noise process \eqn{N(0,1)}.
}
\examples{
set.seed(123456789)
Z<-arima.sim(n=300,list(ar=c(0.5)))
l <- 2
r <- 0
K <- c(2,1)
theta <- matrix(c(1,-0.5,0.5,-0.7,-0.3,NA), nrow=l)
H <- c(1, 1.5)
X <- simu.tar.norm(Z,l,r,K,theta,H)
#res <- ARorder.norm(Z,X,l,r)
#res$K.est
#res$K.prob
}
\references{
Nieto, F. H. (2005), \emph{Modeling Bivariate Threshold Autoregressive Processes in the Presence of Missing Data}. Communications in Statistics. Theory and Methods, 34; 905-930
}
\seealso{
\code{\link{simu.tar.norm}}
}
\author{
Hanwen Zhang <hanwenzhang at usantotomas.edu.co>
}
