% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LS.norm.R
\name{LS.norm}
\alias{LS.norm}
\title{Estimate a Gaussian TAR model using Least Square method given the structural parameters.}
\usage{
LS.norm(Z, X, l, r, K)
}
\arguments{
\item{Z}{The threshold series}

\item{X}{The series of interest}

\item{l}{The number of regimes.}

\item{r}{The vector of thresholds for the series \eqn{\{Z_t\}}.}

\item{K}{The vector containing the autoregressive orders of the \eqn{l} regimes.}
}
\value{
The function returns the autoregressive coefficients matrix theta and variance weights \eqn{H}. Rows of the matrix theta represent regimes
}
\description{
This function estimate a Gaussian TAR model using Least Square method given the structural parameters, i.e. the number of regimes, thresholds and autoregressive orders.
}
\details{
The TAR model is given by \deqn{X_t=a_0^{(j)} + \sum_{i=1}^{k_j}a_i^{(j)}X_{t-i}+h^{(j)}e_t} when \eqn{Z_t\in (r_{j-1},r_j]} for som \eqn{j} (\eqn{j=1,\cdots,l}). 
the \eqn{\{Z_t\}} is the threshold process, \eqn{l} is the number of regimes, \eqn{k_j} is the autoregressive order in the regime \eqn{j}. \eqn{a_i^{(j)}} with \eqn{i=0,1,\cdots,k_j} denote the autoregressive coefficients, while \eqn{h^{(j)}} denote the variance weights.
}
\examples{
Z<-arima.sim(n=500,list(ar=c(0.5)))
l <- 2
r <- 0
K <- c(2,1)
theta <- matrix(c(1,-0.5,0.5,-0.7,-0.3,NA), nrow=l)
H <- c(1, 1.5)
X <- simu.tar.norm(Z,l,r,K,theta,H)
LS.norm(Z,X,l,r,c(0,0))
}
\references{
Nieto, F. H. (2005), \emph{Modeling Bivariate Threshold Autoregressive Processes in the Presence of Missing Data}. Communications in Statistics. Theory and Methods, 34; 905-930
}
\seealso{
\code{\link{simu.tar.norm}}
}
\author{
Hanwen Zhang <hanwenzhang at usantotomas.edu.co>
}
