% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.tar.lognorm.R
\name{simu.tar.lognorm}
\alias{simu.tar.lognorm}
\title{Simulate a series from a log-normal TAR model with Gaussian distributed error for positive valued time series.}
\usage{
simu.tar.lognorm(Z, l, r, K, theta, H)
}
\arguments{
\item{Z}{The threshold series}

\item{l}{The number of regimes.}

\item{r}{The vector of thresholds for the series \eqn{\{Z_t\}}.}

\item{K}{The vector containing the autoregressive orders of the \eqn{l} regimes.}

\item{theta}{The matrix of autoregressive coefficients of dimension \eqn{l\times\max{K}}. \eqn{j}-th row contains the autoregressive coefficients of regime \eqn{j}.}

\item{H}{The vector containing the variance weights of the \eqn{l} regimes.}
}
\value{
The time series \eqn{\{X_t\}}.
}
\description{
This function simulates a serie from  a log-normal TAR model with Gaussian distributed error given the parameters of the model from a given threshold process \eqn{\{Z_t\}}
}
\details{
The TAR model is given by \deqn{X_t=a_0^{(j)} + \sum_{i=1}^{k_j}a_i^{(j)}X_{t-i}+h^{(j)}e_t} when \eqn{Z_t\in (r_{j-1},r_j]} for som \eqn{j} (\eqn{j=1,\cdots,l}). 
the \eqn{\{Z_t\}} is the threshold process, \eqn{l} is the number of regimes, \eqn{k_j} is the autoregressive order in the regime \eqn{j}. \eqn{a_i^{(j)}} with \eqn{i=0,1,\cdots,k_j} denote the autoregressive coefficients, while \eqn{h^{(j)}} denote the variance weights. \eqn{\{e_t\}} is the Gaussian white noise process \eqn{N(0,1)}.
}
\examples{
set.seed(12345678)
Z<-arima.sim(n=500,list(ar=c(0.5)))
l <- 2
r <- 0
K <- c(2,1)
theta <- matrix(c(1,0.5,-0.3,-0.5,-0.7,NA),nrow=l)
H <- c(1, 1.3)
X <- simu.tar.lognorm(Z,l,r,K,theta,H)
ts.plot(X)

}
\references{
Nieto, F. H. (2005), \emph{Modeling Bivariate Threshold Autoregressive Processes in the Presence of Missing Data}. Communications in Statistics. Theory and Methods, 34; 905-930
}
\seealso{
\code{\link{simu.tar.norm}}
}
\author{
Hanwen Zhang <hanwenzhang at usantotomas.edu.co>
}
