% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_lookup.R
\name{parse_imgt_fasta}
\alias{parse_imgt_fasta}
\title{Extract gene names from a reference FASTA}
\usage{
parse_imgt_fasta(infile)
}
\arguments{
\item{infile}{A string, the path to FASTA file.}
}
\value{
A character vector of gene names.
}
\description{
\code{parse_imgt_fasta()} extracts the second element from a "|"-delimited FASTA
header, which will be the gene name for IMGT reference FASTAs.
}
\examples{
# Given a FASTA file containing this header:
#   >SomeText|TRBV29-1*01|MoreText|
#   >SomeText|TRBV29-1*02|MoreText|
#   >SomeText|TRBV29/OR9-2*01|MoreText|

fasta <- get_example_path("fasta_dir/test_trbv.fa")
parse_imgt_fasta(fasta)
}
\keyword{internal}
