% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tmax.R
\name{Tmax.mean}
\alias{Tmax.mean}
\title{Calculate a mean of Tmax}
\usage{
Tmax.mean(df)
}
\arguments{
\item{df}{Data frame containing all Tmax for each sub-group.}
}
\value{
Return the inputed data frame with a new column names "Tmax_mean".
}
\description{
Calculate a mean Tmax for each sub-group
}
\details{
The data frame should contain a column named "Tmax" whith all Tmax and a column named "ID" to identify which Tmax belong to which sug-group.
}
\examples{
ID = c(rep("A", times=5), rep("B", times=5), rep("A", times=5), rep("B", times=5))
Tmax = c(rep(2.5, times=5), rep(2.7, times=5), rep(3.2, times=5), rep(3.4, times=5))
DOY = c(rep(102, times=10), rep(103, times=10))
df <- data.frame(DOY, ID, Tmax)
Tmax.mean(df)
}
