##' A catalogue of annotated target genes based on TFactS.
##'
##' This was downloaded from TFactS (http://www.tfacts.org/).
##'
##' The catalogues version is 2
##' (http://www.tfacts.org/TFactS-new/TFactS-v2/tfacts/data/Catalogues.xls).
##'
##' @name catalog
##' @docType data
##' @aliases catalog
##' @title A list of TF-target genes (TG) in TFactS.
##' @return None
##' @keywords datasets
##' @references Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
##' @author Atsushi Fukushima
NULL


##' An example list of differentially expressed genes (DEGs).
##'
##' This was from DEMO data in TFactS (http://www.tfacts.org/).
##' The list corresponds to 18 up-regulated genes.
##'
##' @name DEGs
##' @docType data
##' @aliases DEGs
##' @title An example list of DEGs from DEMO data in TFactS.
##' @return None
##' @keywords datasets
##' @references Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
##' @author Atsushi Fukushima
NULL

##' A list of 39 differentially expressed genes (DEGs).
##'
##' This was from DEMO data in TFactS (http://www.tfacts.org/). The list
##' corresponds to 18 up-regulated genes and 21 down-regulated genes.
##'
##' @name DEGs39
##' @docType data
##' @aliases DEGs39
##' @title An example list of 39 DEGs from DEMO data in TFactS.
##' @return None
##' @keywords datasets
##' @references Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
##' @author Atsushi Fukushima
NULL


##' An example result of enrichment analysis
##'
##' The size of data frame is 345 TFs and 6 columns.
##'
##' @name example.df
##' @docType data
##' @aliases example.df
##' @title An example result of enrichment analysis
##' @return None
##' @keywords datasets
##' @references Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
##' @author Atsushi Fukushima
NULL


##' An example list of result of enrichment analysis
##'
##' The length of the list is 345 (TFs).
##'
##' @name example.list
##' @docType data
##' @aliases example.list
##' @title An example list of result of enrichment analysis
##' @return None
##' @keywords datasets
##' @references Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
##' @author Atsushi Fukushima
NULL

##' A catalogue of annotated target genes in Arabidopsis thaliana
##'
##' The original regulatory network datasets were downloaded from AtRegNet
##' - AGRIS Arabidopsis
##' (http://arabidopsis.med.ohio-state.edu/moreNetwork.html)
##' and ATRM (http://atrm.cbi.pku.edu.cn/), respectively. Then we integrated
##' them based on AGI code.
##'
##' The catalogues version is 0.0.1.
##'
##' @name AtCatalog
##' @docType data
##' @aliases AtCatalog
##' @title A list of TF-target genes (TG) in Arabidopsis thaliana.
##' @return None
##' @keywords datasets
##' @references Yilmaz A et al. NAR 39:D1118-1122 (2011)
##' @author Atsushi Fukushima
NULL

##' A list of 74 differentially expressed genes (DEGs) from AtGenExpress
##'
##' This was from DEMO data in the Supplemental data (Table S4. Genes
##' regulated by UV-B light stress in roots and shoots; filename:
##' TPJ_3052_sm_TabS4.xls) of the paper by Killian et al. TPJ (2008).
##' The list corresponds to 74 genes up-regulated in roots and shoots 1 hour
##' after onset of UV-B stress treatment.
##'
##' @name GenesUp_SH1H
##' @docType data
##' @aliases GenesUp_SH1H
##' @title An example list of 74 DEGs from AtGenExpress stress dataset.
##' @return None
##' @keywords datasets
##' @references Killian J et al. Plant J. 2007 Apr;50(2):347-363.
##' @author Atsushi Fukushima
NULL
