% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.tfisher.R
\name{p.tfisher}
\alias{p.tfisher}
\title{CDF of thresholding Fisher's p-value combination statistic under the null hypothesis.}
\usage{
p.tfisher(q, n, tau1, tau2, M = NULL, mu = NULL, sigma2 = NULL,
  p0 = NULL)
}
\arguments{
\item{q}{- quantile, could be a vector.}

\item{n}{- dimension parameter, i.e. the number of p-values to be combined.}

\item{tau1}{- truncation parameter. 0 < tau1 <= 1.}

\item{tau2}{- normalization parameter. tau2 >= tau1.}

\item{M}{- correlation matrix of the input statistics. Default = NULL assumes independence.}

\item{mu}{- the mean of TFisher statistics. Default = NULL.}

\item{sigma2}{- the variance of TFisher statistics. Default = NULL.}

\item{p0}{- the point masse of TFisher statistics. Default = NULL.}
}
\value{
The left-tail probability of the null distribution of thresholding Fisher's p-value combination statistic at the given quantile.
}
\description{
CDF of thresholding Fisher's p-value combination statistic under the null hypothesis.
}
\examples{
pval <- runif(20)
tfstat <- stat.tfisher(p=pval, tau1=0.25, tau2=0.75)
p.tfisher(q=tfstat, n=20, tau1=0.25, tau2=0.75)
M = matrix(0.3,20,20) + diag(1-0.3,20)
p.tfisher(q=tfstat, n=20, tau1=0.25, tau2=0.75, M=M)
}
\references{
1. Hong Zhang and Zheyang Wu. "TFisher Tests: Optimal and Adaptive Thresholding for Combining p-Values", submitted.
}
\seealso{
\code{\link{stat.tfisher}} for the definition of the statistic.
}
