% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/THREC.R
\name{conifers}
\alias{conifers}
\title{A response calibration function for the other conifer species}
\usage{
conifers(DATA)
}
\arguments{
\item{DATA}{data frame containing at least yta, rev, t_l, dia, hdom, ddom, and hojd.}
}
\value{
data frame with estimated height
}
\description{
This function performs a response calibration of the height function for other conifer species. The other conifer species include: Silver fir, Douglas fir, Sitka spruce, Siberian larch, European larch, other larch, Lodgepole pine, other fir, other spruces.
}
\note{
yta: plot number, rev: revision, t_l: species code, dia: diameter at breast height, hdom: height of the tree with the largest diameter (ddom) regardless of the species (m), hojd: sample tree height with missing values. In cases where hdom is not present in the inventory data, site index (SI) can serve as an alternative, although the estimated height may exhibit slight variations.
}
\examples{
library(THREC)

# sample data
data(broad)

conifers(broad)
}
\references{
Ogana et al. (2023) https://doi.org/10.1016/j.foreco.2023.120843

Arias-Rodil et al. (2015) https://doi.org/10.1371/JOURNAL.PONE.0143521
}
\seealso{
\code{\link[=broadleaves]{broadleaves()}}, which estimate the tree height of 'other broadleaves'.
}
\author{
Ogana F.N. and Arias-Rodil M.
}
\keyword{conifers}
