% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf.R
\name{cTLCAR}
\alias{cTLCAR}
\title{Cumulative Distribution Function (CDF) for the TLCAR Distribution}
\usage{
cTLCAR(x, alpha, a, b, theta, m)
}
\arguments{
\item{x}{Value at which to calculate the CDF.}

\item{alpha}{Parameter representing the distribution of the Topp-Leone component.}

\item{a}{Parameter representing the scale (a) of the Cauchy component.}

\item{b}{Parameter representing the position (b) of the Cauchy component.}

\item{theta}{Parameter representing the scale of the Rayleigh component.}

\item{m}{Additional parameter.}
}
\value{
Cumulative distribution at the given value.
}
\description{
Calculate the cumulative distribution at a given value using the TLCAR distribution.
}
\details{
The cumulative distribution function (CDF) for the TLCAR distribution is defined as follows:

\deqn{F(x)=\left[ 1-\left(\frac{1}{2}-\frac{1}{\pi}\arctan\frac{x\left(1-e^{-\frac{x^2}{2\theta^2}}+m\right) -b}{a}\right)^2\right]^\alpha}
}
\examples{
cTLCAR(x = 1, alpha = 1, a = 1, b = 0, theta = 2, m = 0.5)

}
