
# This file is automatically generated, you probably don't want to edit this

dataTOSTrOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "dataTOSTrOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            pairs = NULL,
            cor_type = "pearson",
            hypothesis = "EQU",
            low_eqbound_r = -0.3,
            high_eqbound_r = 0.3,
            alpha = 0.05,
            desc = FALSE,
            plots = FALSE, ...) {

            super$initialize(
                package="TOSTER",
                name="dataTOSTr",
                requiresData=TRUE,
                ...)

            private$..pairs <- jmvcore::OptionPairs$new(
                "pairs",
                pairs,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..cor_type <- jmvcore::OptionList$new(
                "cor_type",
                cor_type,
                options=list(
                    "pearson",
                    "spearman",
                    "kendall"),
                default="pearson")
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "EQU",
                    "MET"),
                default="EQU")
            private$..low_eqbound_r <- jmvcore::OptionNumber$new(
                "low_eqbound_r",
                low_eqbound_r,
                default=-0.3)
            private$..high_eqbound_r <- jmvcore::OptionNumber$new(
                "high_eqbound_r",
                high_eqbound_r,
                default=0.3)
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                min=0,
                max=1,
                default=0.05)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)

            self$.addOption(private$..pairs)
            self$.addOption(private$..cor_type)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..low_eqbound_r)
            self$.addOption(private$..high_eqbound_r)
            self$.addOption(private$..alpha)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
        }),
    active = list(
        pairs = function() private$..pairs$value,
        cor_type = function() private$..cor_type$value,
        hypothesis = function() private$..hypothesis$value,
        low_eqbound_r = function() private$..low_eqbound_r$value,
        high_eqbound_r = function() private$..high_eqbound_r$value,
        alpha = function() private$..alpha$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value),
    private = list(
        ..pairs = NA,
        ..cor_type = NA,
        ..hypothesis = NA,
        ..low_eqbound_r = NA,
        ..high_eqbound_r = NA,
        ..alpha = NA,
        ..desc = NA,
        ..plots = NA)
)

dataTOSTrResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "dataTOSTrResults",
    inherit = jmvcore::Group,
    active = list(
        text = function() private$.items[["text"]],
        tost = function() private$.items[["tost"]],
        desc = function() private$.items[["desc"]],
        plots = function() private$.items[["plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="TOST Correlation")
            self$add(jmvcore::Preformatted$new(
                options=options,
                name="text"))
            self$add(jmvcore::Table$new(
                options=options,
                name="tost",
                title="TOST Results",
                rows="(pairs)",
                clearWith=list(
                    "alpha",
                    "hypothesis",
                    "low_eqbound_r",
                    "high_eqbound_r"),
                columns=list(
                    list(
                        `name`="i1", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="i2", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="r", 
                        `title`="r", 
                        `type`="number"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"),
                    list(
                        `name`="cil", 
                        `title`="Lower", 
                        `superTitle`="Confidence Interval"),
                    list(
                        `name`="ciu", 
                        `title`="Upper", 
                        `superTitle`="Confidence Interval"),
                    list(
                        `name`="sig", 
                        `title`="Sig. Result", 
                        `type`="Text"),
                    list(
                        `name`="tost", 
                        `title`="TOST Result", 
                        `type`="Text"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(desc)",
                rows="(pairs)",
                clearWith=NULL,
                columns=list(
                    list(
                        `name`="name[1]", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="n[1]", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="m[1]", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med[1]", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd[1]", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se[1]", 
                        `title`="SE", 
                        `type`="number"),
                    list(
                        `name`="name[2]", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="n[2]", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="m[2]", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med[2]", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd[2]", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se[2]", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(pairs)",
                visible="(plots)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".plot",
                    width=425,
                    height=300,
                    clearWith=list(
                        "alpha",
                        "cor_type",
                        "low_eqbound_r",
                        "high_eqbound_r"))))}))

dataTOSTrBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "dataTOSTrBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "TOSTER",
                name = "dataTOSTr",
                version = c(1,0,0),
                options = options,
                results = dataTOSTrResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE,
                requiresMissings = FALSE,
                weightsSupport = 'auto')
        }))

#' TOST Correlation
#'
#' TOST for correlations in jamovi. This function is not meant to be utilized 
#' in R.
#' @param data the data as a data frame
#' @param pairs a list of vectors of strings naming variables to correlate
#'   from \code{data}
#' @param cor_type a character string indicating which correlation coefficient
#'   is to be used for the test. One of "pearson", "kendall", or "spearman", can
#'   be abbreviated.
#' @param hypothesis \code{'EQU'} for equivalence (default), or \code{'MET'}
#'   for minimal effects test, the alternative hypothesis.
#' @param low_eqbound_r lower equivalence bounds (e.g., -0.3) expressed in a
#'   correlation effect size
#' @param high_eqbound_r upper equivalence bounds (e.g., 0.3) expressed in a
#'   correlation effect size
#' @param alpha alpha level (default = 0.05)
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param plots \code{TRUE} or \code{FALSE} (default), provide plots
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
#'   \code{results$tost} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an array of images \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$tost$asDF}
#'
#' \code{as.data.frame(results$tost)}
#'
#' @export
dataTOSTr <- function(
    data,
    pairs,
    cor_type = "pearson",
    hypothesis = "EQU",
    low_eqbound_r = -0.3,
    high_eqbound_r = 0.3,
    alpha = 0.05,
    desc = FALSE,
    plots = FALSE) {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("dataTOSTr requires jmvcore to be installed (restart may be required)")

    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame())


    options <- dataTOSTrOptions$new(
        pairs = pairs,
        cor_type = cor_type,
        hypothesis = hypothesis,
        low_eqbound_r = low_eqbound_r,
        high_eqbound_r = high_eqbound_r,
        alpha = alpha,
        desc = desc,
        plots = plots)

    analysis <- dataTOSTrClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

