% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tscsRegression3D.R
\name{tscsRegression3D}
\alias{tscsRegression3D}
\title{The First Step of TSCS for 3D Rectangular Grid System - Regression}
\usage{
tscsRegression3D(data, h1, h2, v, alpha = 0.05)
}
\arguments{
\item{data}{data frame; should contain these variables in order: X coordinate, Y coordinate, Z coordinate and
observations as time goes on. That is to say, each row should include X, Y and Z coordinate first, and then
a time series. This is the historical spatio-temporal data that you intend to analyze as the basis for
interpolation later on in \code{tscsEstimate3D}.}

\item{h1}{numeric; side length of the unit cubic grid in X coordinate direction (horizontal).}

\item{h2}{numeric; side length of the unit cubic grid in Y coordinate direction (horizontal).}

\item{v}{numeric; side length of the unit cubic grid in Z coordinate direction (vertical).}

\item{alpha}{numeric; specify the significance level for ADF test, to test if the time series of a group of
spatial locations are cointegrated. (default: 0.05)}
}
\value{
A list of 2 is returned, including:
\describe{
  \item{\code{coef_matrix}}{data frame; regression coefficient matrix to be used as input parameter of function
  \code{tscsEstimate} in the second step of TSCS interpolation.}
  \item{\code{percentage}}{numeric; percentage of cointegrated relationships, a measurement of the degree
  it satisfies the assumption of cointegrated system. It is highly affected by parameter \code{alpha},
  the significance level you have set. Explicitly, smaller \code{alpha} results in smaller \code{percentage}.}
}
}
\description{
To implement TSCS spatial interpolation for a spatial domain that is a 3D rectangular grid system,
  the first step is obtaining regression coefficient matrix, which can be done
  by function \code{tscsRegression3D}. It is the prerequisite of TSCS interpolation process
  because the 'matrix' derived from historical spatio-temporal data is the initial value of
  the second step - estimating missing observations.
}
\details{
\itemize{
  \item The second step of TSCS spatial interpolation should be carried out by function \code{tscsEstimate3D},
  where you have to input the cross-section data or pure spatial data of a particular time point
  you have selected, with missing observations that you want to predict.
  \item For 2D rectangular grid system, the procedure of TSCS stays the same.
  Please see \code{tscsRegression} and \code{tscsEstimate}.
  \item Attentions:
  (1) Since TSCS is only capable of interpolation but not extrapolation, it is necessary to highlight the
  difference between interior spatial locations and system boundary. Function \code{plot3D_dif} can help.
  (2) NA value in historical spatio-temporal data \code{data} is not allowed. Please handle them beforehand
  (such as filling these NA values through spatio-temporal kriging).
}
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression3D(data = data, h1 = 3.75, h2 = 2.5, v = 5, alpha = 0.01);
basis$percentage
est <- tscsEstimate3D(matrix = basis$coef_matrix, newdata = newdata, h1 = 3.75, h2 = 2.5, v = 5);
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,4], true = true)
index <- appraisal_index(est = est$estimate[,4], true = true);
index

## data visualization:

plot3D_dif(data = data[,1:3], h1 = 3.75, h2 = 2.5, v = 5)
plot3D_NA(newdata = newdata)
plot3D_map(newdata = newdata)
}
}
\seealso{
\code{\link{tscsEstimate3D}}, \code{\link{tscsRegression}}, \code{\link{plot3D_dif}}
}
