% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepDiscrim.R
\name{StepDiscrimV}
\alias{StepDiscrimV}
\title{Select the most discriminating variables}
\usage{
StepDiscrimV(
  MWA,
  labels,
  VStep,
  features = c("Var", "Cor", "IQR", "PE", "DM"),
  nCores = 0
)
}
\arguments{
\item{MWA}{MultiWaveAnalysis object obtained with MultiWaveAnalysis function}

\item{labels}{Labeled vector that classify the observations.}

\item{VStep}{Determine the minimum value of V to continue adding new
variables. Ex if an determinate step the maximum V is 0.2 but VStep is
0.3 the algorithm end. Must be greater than 0.}

\item{features}{A list of characteristics that will be used for the
classification process. To see the available features see
\code{\link{availableFeatures}}}

\item{nCores}{Determines the number of processes that will be used in the
function, by default it uses all but one of the system cores. Must be
a positive integer, where 0 corresponds to the default behavior}
}
\value{
A MultiWaveAnalysis object with the most discriminant variables.
This Object contains:
* Features: A list with the initial computed features
* StepSelection: The most discriminant variables selected by this
function
* Observations: Number of total observations
* NLevels: Number of levels selected for the decomposition process
* filter: Filter used in the decomposition process
}
\description{
Stepwise discriminant analysis to determine the best subset of variables.
Introduces variables so as to maximize at each step the Lawley-Hotelling
trace (=Rao's V).  This measure is proportional to the mean Mahalanobis
distance.The process ends when in one step the value of the Lawley-Hotelling
trace is less than a given value.
}
\details{
Based on StepDiscrim of R.E. Strauss
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
MWA <- MultiWaveAnalysis(ECGExample, "haar", features = c("var"))
MWADiscrim <- StepDiscrimV(
  MWA, c(rep(1, 5), rep(2, 5)), 0.1,
  c("Var")
)
}
}
\seealso{
\itemize{
\item \code{\link{MultiWaveAnalysis}}
\item \code{\link{StepDiscrim}}
}
}
